/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;

public class FlateFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(FlateFilter.class);
    private static final int BUFFER_SIZE = 16348;

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase baseObj = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary dict = null;
        if (baseObj instanceof COSDictionary) {
            dict = (COSDictionary)baseObj;
        } else if (baseObj instanceof COSArray) {
            COSArray paramArray = (COSArray)baseObj;
            if (filterIndex < paramArray.size()) {
                dict = (COSDictionary)paramArray.getObject(filterIndex);
            }
        } else if (baseObj != null) {
            throw new IOException("Error: Expected COSArray or COSDictionary and not " + baseObj.getClass().getName());
        }
        int predictor = -1;
        int colors = -1;
        int bitsPerPixel = -1;
        int columns = -1;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (dict != null && (predictor = dict.getInt(COSName.PREDICTOR)) > 1) {
            colors = dict.getInt(COSName.COLORS);
            bitsPerPixel = dict.getInt(COSName.BITS_PER_COMPONENT);
            columns = dict.getInt(COSName.COLUMNS);
        }
        try {
            baos = this.decompress(compressedData);
            if (predictor == -1 || predictor == 1) {
                result.write(baos.toByteArray());
            } else {
                if (colors == -1) {
                    colors = 1;
                }
                if (bitsPerPixel == -1) {
                    bitsPerPixel = 8;
                }
                if (columns == -1) {
                    columns = 1;
                }
                bais = new ByteArrayInputStream(baos.toByteArray());
                byte[] decodedData = this.decodePredictor(predictor, colors, bitsPerPixel, columns, bais);
                bais.close();
                bais = null;
                result.write(decodedData);
            }
            result.flush();
        }
        catch (DataFormatException exception) {
            LOG.error((Object)"FlateFilter: stop reading corrupt stream due to a DataFormatException");
            IOException io = new IOException();
            io.initCause(exception);
            throw io;
        }
        finally {
            if (bais != null) {
                bais.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private ByteArrayOutputStream decompress(InputStream in) throws IOException, DataFormatException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater();
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[2048];
            while (true) {
                int resRead;
                if ((resRead = inflater.inflate(res)) != 0) {
                    out.write(res, 0, resRead);
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
        }
        out.close();
        return out;
    }

    private byte[] decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        if (predictor == 1) {
            int i = 0;
            while ((i = data.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
        } else {
            int bitsPerPixel = colors * bitsPerComponent;
            int bytesPerPixel = (bitsPerPixel + 7) / 8;
            int rowlength = (columns * bitsPerPixel + 7) / 8;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            boolean done = false;
            int linepredictor = predictor;
            while (!done && data.available() > 0) {
                if (predictor >= 10) {
                    linepredictor = data.read();
                    if (linepredictor == -1) {
                        done = true;
                        break;
                    }
                    linepredictor += 10;
                }
                int i = 0;
                for (int offset = 0; offset < rowlength && (i = data.read(actline, offset, rowlength - offset)) != -1; offset += i) {
                }
                switch (linepredictor) {
                    case 2: {
                        int left;
                        int sub;
                        int p;
                        if (bitsPerComponent != 8) {
                            throw new IOException("TIFF-Predictor with " + bitsPerComponent + " bits per component not supported");
                        }
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        int left;
                        int sub;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p];
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 12: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior & 0xFF);
                        }
                        break;
                    }
                    case 13: {
                        int left;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int avg = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (int)Math.floor((left + up) / 2) & 0xFF);
                        }
                        break;
                    }
                    case 14: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int paeth = actline[p] & 0xFF;
                            int a = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int b = lastline[p] & 0xFF;
                            int c = p - bytesPerPixel >= 0 ? lastline[p - bytesPerPixel] & 0xFF : 0;
                            int value = a + b - c;
                            int absa = Math.abs(value - a);
                            int absb = Math.abs(value - b);
                            int absc = Math.abs(value - c);
                            actline[p] = absa <= absb && absa <= absc ? (byte)(paeth + a & 0xFF) : (absb <= absc ? (byte)(paeth + b & 0xFF) : (byte)(paeth + c & 0xFF));
                        }
                        break;
                    }
                }
                lastline = (byte[])actline.clone();
                baos.write(actline, 0, actline.length);
            }
        }
        return baos.toByteArray();
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        DeflaterOutputStream out = new DeflaterOutputStream(result);
        int amountRead = 0;
        int mayRead = rawData.available();
        if (mayRead > 0) {
            byte[] buffer = new byte[Math.min(mayRead, 16348)];
            while ((amountRead = rawData.read(buffer, 0, Math.min(mayRead, 16348))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        result.flush();
    }
}

