/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDPatternResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDColorSpaceFactory {
    private PDColorSpaceFactory() {
    }

    public static PDColorSpace createColorSpace(COSBase colorSpace) throws IOException {
        return PDColorSpaceFactory.createColorSpace(colorSpace, null);
    }

    public static PDColorSpace createColorSpace(COSBase colorSpace, Map<String, PDColorSpace> colorSpaces) throws IOException {
        return PDColorSpaceFactory.createColorSpace(colorSpace, colorSpaces, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PDColorSpace createColorSpace(COSBase colorSpace, Map<String, PDColorSpace> colorSpaces, Map<String, PDPatternResources> patterns) throws IOException {
        PDColorSpace retval = null;
        if (colorSpace instanceof COSObject) {
            return PDColorSpaceFactory.createColorSpace(((COSObject)colorSpace).getObject(), colorSpaces);
        }
        if (colorSpace instanceof COSName) {
            return PDColorSpaceFactory.createColorSpace(((COSName)colorSpace).getName(), colorSpaces);
        }
        if (!(colorSpace instanceof COSArray)) throw new IOException("Unknown colorspace type:" + colorSpace);
        COSArray array = (COSArray)colorSpace;
        String name = ((COSName)array.getObject(0)).getName();
        if (name.equals("CalGray")) {
            return new PDCalGray(array);
        }
        if (name.equals("DeviceRGB")) {
            return PDDeviceRGB.INSTANCE;
        }
        if (name.equals("DeviceGray")) {
            return new PDDeviceGray();
        }
        if (name.equals("DeviceCMYK")) {
            return PDDeviceCMYK.INSTANCE;
        }
        if (name.equals("CalRGB")) {
            return new PDCalRGB(array);
        }
        if (name.equals("DeviceN")) {
            return new PDDeviceN(array);
        }
        if (name.equals("Indexed")) return new PDIndexed(array);
        if (name.equals("I")) {
            return new PDIndexed(array);
        }
        if (name.equals("Lab")) {
            return new PDLab(array);
        }
        if (name.equals("Separation")) {
            return new PDSeparation(array);
        }
        if (name.equals("ICCBased")) {
            return new PDICCBased(array);
        }
        if (!name.equals("Pattern")) throw new IOException("Unknown colorspace array type:" + name);
        return new PDPattern(array);
    }

    public static PDColorSpace createColorSpace(String colorSpaceName) throws IOException {
        return PDColorSpaceFactory.createColorSpace(colorSpaceName, null);
    }

    public static PDColorSpace createColorSpace(String colorSpaceName, Map<String, PDColorSpace> colorSpaces) throws IOException {
        PDColorSpace cs = null;
        if (colorSpaceName.equals("DeviceCMYK") || colorSpaceName.equals("CMYK")) {
            cs = PDDeviceCMYK.INSTANCE;
        } else if (colorSpaceName.equals("DeviceRGB") || colorSpaceName.equals("RGB")) {
            cs = PDDeviceRGB.INSTANCE;
        } else if (colorSpaceName.equals("DeviceGray") || colorSpaceName.equals("G")) {
            cs = new PDDeviceGray();
        } else if (colorSpaces != null && colorSpaces.get(colorSpaceName) != null) {
            cs = colorSpaces.get(colorSpaceName);
        } else if (colorSpaceName.equals("Lab")) {
            cs = new PDLab();
        } else if (colorSpaceName.equals("Pattern")) {
            cs = new PDPattern();
        } else {
            throw new IOException("Error: Unknown colorspace '" + colorSpaceName + "'");
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDColorSpace createColorSpace(PDDocument doc, ColorSpace cs) throws IOException {
        PDColorSpace retval = null;
        if (cs.isCS_sRGB()) {
            retval = PDDeviceRGB.INSTANCE;
        } else if (cs instanceof ICC_ColorSpace) {
            ICC_ColorSpace ics = (ICC_ColorSpace)cs;
            PDICCBased pdCS = new PDICCBased(doc);
            retval = pdCS;
            COSArray ranges = new COSArray();
            for (int i = 0; i < cs.getNumComponents(); ++i) {
                ranges.add(new COSFloat(ics.getMinValue(i)));
                ranges.add(new COSFloat(ics.getMaxValue(i)));
            }
            PDStream iccData = pdCS.getPDStream();
            OutputStream output = null;
            try {
                output = iccData.createOutputStream();
                output.write(ics.getProfile().getData());
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
            pdCS.setNumberOfComponents(cs.getNumComponents());
        } else {
            throw new IOException("Not yet implemented:" + cs);
        }
        return retval;
    }
}

