/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;

public class CompositeImage {
    private BufferedImage baseImage;
    private BufferedImage smaskImage;

    public CompositeImage(BufferedImage baseImage, BufferedImage smaskImage) {
        this.baseImage = baseImage;
        this.smaskImage = smaskImage;
    }

    public BufferedImage createMaskedImage(COSArray decodeArray) throws IOException {
        boolean isOpaque = false;
        if (decodeArray != null) {
            isOpaque = decodeArray.getInt(0) > decodeArray.getInt(1);
        }
        int baseImageWidth = this.baseImage.getWidth();
        int baseImageHeight = this.baseImage.getHeight();
        BufferedImage result = new BufferedImage(baseImageWidth, baseImageHeight, 2);
        for (int x = 0; x < baseImageWidth; ++x) {
            for (int y = 0; y < baseImageHeight; ++y) {
                int rgb = this.baseImage.getRGB(x, y);
                int alpha = this.smaskImage.getRGB(x, y);
                int rgbOnly = 0xFFFFFF & rgb;
                if (isOpaque) {
                    alpha ^= 0xFFFFFFFF;
                }
                int alphaOnly = alpha << 24;
                result.setRGB(x, y, rgbOnly | alphaOnly);
            }
        }
        return result;
    }

    public BufferedImage createStencilMaskedImage(COSArray decodeArray) {
        int alphaValue = 0;
        if (decodeArray != null) {
            alphaValue = decodeArray.getInt(0) > decodeArray.getInt(1) ? 1 : 0;
        }
        int baseImageWidth = this.baseImage.getWidth();
        int baseImageHeight = this.baseImage.getHeight();
        WritableRaster maskRaster = this.smaskImage.getRaster();
        BufferedImage result = new BufferedImage(baseImageWidth, baseImageHeight, 2);
        int[] alpha = new int[1];
        for (int x = 0; x < baseImageWidth; ++x) {
            for (int y = 0; y < baseImageHeight; ++y) {
                maskRaster.getPixel(x, y, alpha);
                int rgbOnly = 0xFFFFFF & this.baseImage.getRGB(x, y);
                int alphaOnly = alpha[0] == alphaValue ? -16777216 : 0;
                result.setRGB(x, y, rgbOnly | alphaOnly);
            }
        }
        return result;
    }
}

