/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeNameSpace;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.TypeSystemMgr;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASMetadata;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.StringTypeImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeNameSpaceImpl;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.StringToIntMap;
import org.apache.uima.internal.util.SymbolTable;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSystemImpl
implements TypeSystemMgr,
LowLevelTypeSystem {
    private static Map<String, String> arrayComponentTypeNameMap = new HashMap<String, String>();
    private static Map<String, String> arrayTypeComponentNameMap = new HashMap<String, String>();
    private static final String arrayTypeSuffix = "[]";
    private SymbolTable typeNameST = new SymbolTable(1);
    private SymbolTable featureNameST = new SymbolTable(1);
    private StringToIntMap featureMap = new StringToIntMap();
    private List<IntVector> tree = new ArrayList<IntVector>();
    private List<BitSet> subsumes;
    private IntVector intro;
    private IntVector featRange;
    private ArrayList<IntVector> approp;
    private int top;
    private List<Type> types;
    private List<Feature> features;
    private final IntVector parents;
    private final List<String[]> stringSets;
    private final IntRedBlackTree stringSetMap;
    private final IntRedBlackTree componentToArrayTypeMap;
    private final IntRedBlackTree arrayToComponentTypeMap;
    private final RedBlackTree<TypeImpl> arrayCodeToTypeMap;
    private boolean locked = false;
    private static final int LEAST_TYPE_CODE = 1;
    private static final int LEAST_FEATURE_CODE = 1;
    private int numCommittedTypes = 0;
    final CASMetadata casMetadata;
    boolean areBuiltInTypesSetup = false;
    TypeImpl intType;
    TypeImpl stringType;
    TypeImpl floatType;
    TypeImpl arrayBaseType;
    TypeImpl intArrayType;
    TypeImpl floatArrayType;
    TypeImpl stringArrayType;
    TypeImpl fsArrayType;
    TypeImpl sofaType;
    TypeImpl annotType;
    TypeImpl annotBaseType;
    TypeImpl docType;
    FeatureImpl startFeat;
    FeatureImpl endFeat;
    FeatureImpl langFeat;
    FeatureImpl sofaNum;
    TypeImpl byteType;
    TypeImpl byteArrayType;
    TypeImpl booleanType;
    TypeImpl booleanArrayType;
    TypeImpl shortType;
    TypeImpl shortArrayType;
    TypeImpl longType;
    TypeImpl longArrayType;
    TypeImpl doubleType;
    TypeImpl doubleArrayType;
    int intTypeCode = 0;
    int stringTypeCode = 0;
    int floatTypeCode = 0;
    int arrayBaseTypeCode = 0;
    int intArrayTypeCode = 0;
    int floatArrayTypeCode = 0;
    int stringArrayTypeCode = 0;
    int fsArrayTypeCode = 0;
    int sofaTypeCode = 0;
    int annotTypeCode = 0;
    int annotBaseTypeCode = 0;
    int byteTypeCode = 0;
    int booleanTypeCode = 0;
    int shortTypeCode = 0;
    int longTypeCode = 0;
    int doubleTypeCode = 0;
    int byteArrayTypeCode = 0;
    int booleanArrayTypeCode = 0;
    int shortArrayTypeCode = 0;
    int longArrayTypeCode = 0;
    int doubleArrayTypeCode = 0;
    public int sofaNumFeatCode = 0;
    int sofaIdFeatCode = 0;
    int sofaMimeFeatCode = 0;
    int sofaUriFeatCode = 0;
    int sofaArrayFeatCode = 0;
    public int annotSofaFeatCode = 0;
    int startFeatCode = 0;
    int endFeatCode = 0;
    int langFeatCode = 0;

    @Deprecated
    public TypeSystemImpl(CASImpl cas) {
        this();
    }

    public TypeSystemImpl() {
        this.tree.add(null);
        this.subsumes = new ArrayList<BitSet>();
        this.subsumes.add(null);
        this.intro = new IntVector();
        this.intro.add(0);
        this.featRange = new IntVector();
        this.featRange.add(0);
        this.approp = new ArrayList();
        this.approp.add(null);
        this.types = new ArrayList<Type>();
        this.types.add(null);
        this.features = new ArrayList<Feature>();
        this.features.add(null);
        this.stringSets = new ArrayList<String[]>();
        this.stringSetMap = new IntRedBlackTree();
        this.componentToArrayTypeMap = new IntRedBlackTree();
        this.arrayToComponentTypeMap = new IntRedBlackTree();
        this.arrayCodeToTypeMap = new RedBlackTree();
        this.parents = new IntVector();
        this.parents.add(0);
        this.casMetadata = new CASMetadata(this);
        CASImpl.setupTSDefault(this);
        this.initTypeVariables();
    }

    final void initTypeVariables() {
        this.intType = (TypeImpl)this.getType("uima.cas.Integer");
        this.stringType = (TypeImpl)this.getType("uima.cas.String");
        this.floatType = (TypeImpl)this.getType("uima.cas.Float");
        this.arrayBaseType = (TypeImpl)this.getType("uima.cas.ArrayBase");
        this.intArrayType = (TypeImpl)this.getType("uima.cas.IntegerArray");
        this.floatArrayType = (TypeImpl)this.getType("uima.cas.FloatArray");
        this.stringArrayType = (TypeImpl)this.getType("uima.cas.StringArray");
        this.fsArrayType = (TypeImpl)this.getType("uima.cas.FSArray");
        this.sofaType = (TypeImpl)this.getType("uima.cas.Sofa");
        this.annotType = (TypeImpl)this.getType("uima.tcas.Annotation");
        this.sofaNum = (FeatureImpl)this.getFeatureByFullName("uima.cas.Sofa:sofaNum");
        this.annotBaseType = (TypeImpl)this.getType("uima.cas.AnnotationBase");
        this.startFeat = (FeatureImpl)this.getFeatureByFullName("uima.tcas.Annotation:begin");
        this.endFeat = (FeatureImpl)this.getFeatureByFullName("uima.tcas.Annotation:end");
        this.langFeat = (FeatureImpl)this.getFeatureByFullName("uima.tcas.DocumentAnnotation:language");
        this.docType = (TypeImpl)this.getType("uima.tcas.DocumentAnnotation");
        this.byteType = (TypeImpl)this.getType("uima.cas.Byte");
        this.byteArrayType = (TypeImpl)this.getType("uima.cas.ByteArray");
        this.booleanType = (TypeImpl)this.getType("uima.cas.Boolean");
        this.booleanArrayType = (TypeImpl)this.getType("uima.cas.BooleanArray");
        this.shortType = (TypeImpl)this.getType("uima.cas.Short");
        this.shortArrayType = (TypeImpl)this.getType("uima.cas.ShortArray");
        this.longType = (TypeImpl)this.getType("uima.cas.Long");
        this.longArrayType = (TypeImpl)this.getType("uima.cas.LongArray");
        this.doubleType = (TypeImpl)this.getType("uima.cas.Double");
        this.doubleArrayType = (TypeImpl)this.getType("uima.cas.DoubleArray");
        this.initTypeCodeVars();
    }

    private final void initTypeCodeVars() {
        this.intTypeCode = this.intType.getCode();
        this.stringTypeCode = this.stringType.getCode();
        this.floatTypeCode = this.floatType.getCode();
        this.intArrayTypeCode = this.intArrayType.getCode();
        this.floatArrayTypeCode = this.floatArrayType.getCode();
        this.stringArrayTypeCode = this.stringArrayType.getCode();
        this.fsArrayTypeCode = this.fsArrayType.getCode();
        this.sofaTypeCode = this.sofaType.getCode();
        this.annotTypeCode = this.annotType.getCode();
        this.annotBaseTypeCode = this.annotBaseType.getCode();
        this.byteArrayTypeCode = this.byteArrayType.getCode();
        this.byteTypeCode = this.byteType.getCode();
        this.booleanTypeCode = this.booleanType.getCode();
        this.booleanArrayTypeCode = this.booleanArrayType.getCode();
        this.shortTypeCode = this.shortType.getCode();
        this.shortArrayTypeCode = this.shortArrayType.getCode();
        this.longTypeCode = this.longType.getCode();
        this.longArrayTypeCode = this.longArrayType.getCode();
        this.doubleTypeCode = this.doubleType.getCode();
        this.doubleArrayTypeCode = this.doubleArrayType.getCode();
        this.arrayBaseTypeCode = this.arrayBaseType.getCode();
        TypeImpl sofaT = this.sofaType;
        this.sofaNumFeatCode = this.ll_getCodeForFeature(sofaT.getFeatureByBaseName("sofaNum"));
        this.sofaIdFeatCode = this.ll_getCodeForFeature(sofaT.getFeatureByBaseName("sofaID"));
        this.sofaMimeFeatCode = this.ll_getCodeForFeature(sofaT.getFeatureByBaseName("mimeType"));
        this.sofaUriFeatCode = this.ll_getCodeForFeature(sofaT.getFeatureByBaseName("sofaURI"));
        this.sofaArrayFeatCode = this.ll_getCodeForFeature(sofaT.getFeatureByBaseName("sofaArray"));
        this.annotSofaFeatCode = this.ll_getCodeForFeature(this.annotBaseType.getFeatureByBaseName("sofa"));
        this.startFeatCode = this.ll_getCodeForFeature(this.annotType.getFeatureByBaseName("begin"));
        this.endFeatCode = this.ll_getCodeForFeature(this.annotType.getFeatureByBaseName("end"));
        this.langFeatCode = this.ll_getCodeForFeature(this.docType.getFeatureByBaseName("language"));
    }

    final int getSmallestType() {
        return 1;
    }

    final int getSmallestFeature() {
        return 1;
    }

    final int getTypeArraySize() {
        return this.getNumberOfTypes() + this.getSmallestType();
    }

    public Vector<Feature> getIntroFeatures(Type type) {
        Vector<Feature> feats = new Vector<Feature>();
        List<Feature> appropFeats = type.getFeatures();
        int max = appropFeats.size();
        for (int i = 0; i < max; ++i) {
            Feature feat = appropFeats.get(i);
            if (feat.getDomain() != type) continue;
            feats.add(feat);
        }
        return feats;
    }

    @Override
    public Type getParent(Type t) {
        return ((TypeImpl)t).getSuperType();
    }

    @Override
    public int ll_getParentType(int typeCode) {
        return this.parents.get(typeCode);
    }

    int ll_computeArrayParentFromComponentType(int componentType) {
        if (this.ll_isPrimitiveType(componentType) || this.ll_getTypeForCode(componentType).getName().equals("uima.cas.TOP")) {
            return this.arrayBaseTypeCode;
        }
        return this.fsArrayTypeCode;
    }

    public boolean isApprop(int type, int feat) {
        return this.subsumes(this.intro(feat), type);
    }

    public final int getLargestTypeCode() {
        return this.getNumberOfTypes();
    }

    public boolean isType(int type) {
        return type > 0 && type <= this.getLargestTypeCode();
    }

    @Override
    public Type getType(String typeName) {
        int typeCode = this.ll_getCodeForTypeName(typeName);
        if (typeCode < 1) {
            return null;
        }
        return this.types.get(typeCode);
    }

    @Override
    public Feature getFeatureByFullName(String featureName) {
        return this.ll_getFeatureForCode(this.featureMap.get(featureName));
    }

    private static final String getArrayTypeName(String typeName) {
        String arrayTypeName = arrayComponentTypeNameMap.get(typeName);
        return null == arrayTypeName ? typeName + arrayTypeSuffix : arrayTypeName;
    }

    static final String getArrayComponentName(String arrayTypeName) {
        return arrayTypeName.substring(0, arrayTypeName.length() - 2);
    }

    static boolean isArrayTypeNameButNotBuiltIn(String typeName) {
        return typeName.endsWith(arrayTypeSuffix);
    }

    private static final String getBuiltinArrayComponent(String typeName) {
        return arrayTypeComponentNameMap.get(typeName);
    }

    @Override
    public Type addType(String typeName, Type mother) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException(1);
        }
        if (mother.isInheritanceFinal()) {
            CASAdminException e = new CASAdminException(6);
            e.addArgument(mother.getName());
            throw e;
        }
        String componentTypeName = TypeSystemImpl.getBuiltinArrayComponent(typeName);
        if (componentTypeName != null) {
            return this.getArrayType(this.getType(componentTypeName));
        }
        this.checkTypeSyntax(typeName);
        int typeCode = this.addType(typeName, ((TypeImpl)mother).getCode());
        if (typeCode < this.typeNameST.getStart()) {
            return null;
        }
        return this.types.get(typeCode);
    }

    private void checkTypeSyntax(String name) throws CASAdminException {
        if (!TypeSystemUtils.isTypeName(name)) {
            CASAdminException e = new CASAdminException(4);
            e.addArgument(name);
            throw e;
        }
    }

    int addType(String name, int superType) {
        return this.addType(name, superType, false);
    }

    int addType(String name, int superType, boolean isStringType) {
        TypeImpl t;
        if (this.typeNameST.contains(name)) {
            return -1;
        }
        int type = this.typeNameST.set(name);
        this.newType();
        this.tree.get(superType).add(type);
        this.updateSubsumption(type, superType);
        IntVector superApprop = this.approp.get(superType);
        IntVector typeApprop = this.approp.get(type);
        int max = superApprop.size();
        for (int i = 0; i < max; ++i) {
            int featCode = superApprop.get(i);
            typeApprop.add(featCode);
            String feat = name + ':' + this.ll_getFeatureForCode(featCode).getShortName();
            this.featureMap.put(feat, featCode);
        }
        if (isStringType) {
            int stringSetCode = this.stringSets.size();
            this.stringSetMap.put(type, stringSetCode);
            t = new StringTypeImpl(name, type, this);
        } else {
            t = new TypeImpl(name, type, this);
        }
        this.types.add(t);
        this.parents.add(superType);
        this.numCommittedTypes = this.types.size();
        return type;
    }

    @Override
    public Feature addFeature(String featureName, Type domainType, Type rangeType) throws CASAdminException {
        return this.addFeature(featureName, domainType, rangeType, true);
    }

    @Override
    public Feature addFeature(String featureName, Type domainType, Type rangeType, boolean multipleReferencesAllowed) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException(1);
        }
        Feature f = domainType.getFeatureByBaseName(featureName);
        if (f != null && f.getRange().equals(rangeType)) {
            return f;
        }
        if (domainType.isFeatureFinal()) {
            CASAdminException e = new CASAdminException(7);
            e.addArgument(domainType.getName());
            throw e;
        }
        this.checkFeatureNameSyntax(featureName);
        int featCode = this.addFeature(featureName, ((TypeImpl)domainType).getCode(), ((TypeImpl)rangeType).getCode(), multipleReferencesAllowed);
        if (featCode < this.featureNameST.getStart()) {
            return null;
        }
        return this.features.get(featCode);
    }

    private void checkFeatureNameSyntax(String name) throws CASAdminException {
        if (!TypeSystemUtils.isIdentifier(name)) {
            CASAdminException e = new CASAdminException(5);
            e.addArgument(name);
            throw e;
        }
    }

    @Override
    public Iterator<Type> getTypeIterator() {
        ListIterator<Type> it = new ListIterator<Type>(this.types, this.numCommittedTypes);
        it.next();
        return it;
    }

    @Override
    public Iterator<Feature> getFeatures() {
        Iterator<Feature> it = this.features.iterator();
        it.next();
        return it;
    }

    @Override
    public Type getTopType() {
        return this.types.get(this.top);
    }

    @Override
    public List<Type> getProperlySubsumedTypes(Type type) {
        ArrayList<Type> subList = new ArrayList<Type>();
        Iterator<Type> typeIt = this.getTypeIterator();
        while (typeIt.hasNext()) {
            Type t = typeIt.next();
            if (type == t || !this.subsumes(type, t)) continue;
            subList.add(t);
        }
        return subList;
    }

    @Override
    public Vector<Type> getDirectlySubsumedTypes(Type type) {
        return new Vector<Type>(this.getDirectSubtypes(type));
    }

    @Override
    public List<Type> getDirectSubtypes(Type type) {
        if (type.isArray()) {
            return new ArrayList<Type>();
        }
        ArrayList<Type> list = new ArrayList<Type>();
        IntVector sub = this.tree.get(((TypeImpl)type).getCode());
        int max = sub.size();
        for (int i = 0; i < max; ++i) {
            list.add(this.types.get(sub.get(i)));
        }
        return list;
    }

    public boolean directlySubsumes(int t1, int t2) {
        IntVector sub = this.tree.get(t1);
        return sub.contains(t2);
    }

    @Override
    public boolean subsumes(Type superType, Type subType) {
        return this.subsumes(((TypeImpl)superType).getCode(), ((TypeImpl)subType).getCode());
    }

    @Override
    public int[] ll_getAppropriateFeatures(int type) {
        if (type < 1 || type > this.getNumberOfTypes()) {
            return null;
        }
        return this.approp.get(type).toArrayCopy();
    }

    int getFeatureOffset(int feat) {
        return this.approp.get(this.intro.get(feat)).position(feat) + 1;
    }

    public int getNumberOfFeatures() {
        return this.featureNameST.size();
    }

    public int getNumberOfTypes() {
        return this.typeNameST.size();
    }

    public int intro(int feat) {
        return this.intro.get(feat);
    }

    public int range(int feat) {
        return this.featRange.get(feat);
    }

    public int unify(int t1, int t2) {
        if (this.subsumes(t1, t2)) {
            return t2;
        }
        if (this.subsumes(t2, t1)) {
            return t1;
        }
        return -1;
    }

    int addFeature(String shortName, int domain, int range) {
        return this.addFeature(shortName, domain, range, true);
    }

    int addFeature(String shortName, int domain, int range, boolean multiRefsAllowed) {
        int i;
        String name = this.typeNameST.getSymbol(domain) + ':' + shortName;
        List<Type> typesLocal = this.getProperlySubsumedTypes(this.ll_getTypeForCode(domain));
        typesLocal.add(this.ll_getTypeForCode(domain));
        int max = typesLocal.size();
        for (int i2 = 0; i2 < max; ++i2) {
            String featureName = typesLocal.get(i2).getName() + ':' + shortName;
            if (!this.featureMap.containsKey(featureName)) continue;
            Feature oldFeature = this.getFeatureByFullName(featureName);
            Type oldDomain = oldFeature.getDomain();
            Type oldRange = oldFeature.getRange();
            if (range == this.ll_getCodeForType(oldRange)) {
                return -1;
            }
            CASAdminException e = new CASAdminException(11);
            e.addArgument(shortName);
            e.addArgument(this.ll_getTypeForCode(domain).getName());
            e.addArgument(this.ll_getTypeForCode(range).getName());
            e.addArgument(oldDomain.getName());
            e.addArgument(oldRange.getName());
            throw e;
        }
        int feat = this.featureNameST.set(name);
        for (i = 0; i < max; ++i) {
            this.featureMap.put(typesLocal.get(i).getName() + ':' + shortName, feat);
        }
        this.intro.add(domain);
        this.featRange.add(range);
        max = this.typeNameST.size();
        for (i = 1; i <= max; ++i) {
            if (!this.subsumes(domain, i)) continue;
            this.approp.get(i).add(feat);
        }
        this.features.add(new FeatureImpl(feat, name, this, multiRefsAllowed));
        return feat;
    }

    public Type addTopType(String name) {
        int code = this.addTopTypeInternal(name);
        if (code < 1) {
            return null;
        }
        return this.types.get(code);
    }

    private int addTopTypeInternal(String name) {
        if (this.typeNameST.size() > 0) {
            return 0;
        }
        this.top = this.typeNameST.set(name);
        this.newType();
        this.addSubsubsumption(this.top, this.top);
        this.types.add(new TypeImpl(name, this.top, this));
        this.parents.add(0);
        this.numCommittedTypes = this.types.size();
        return this.top;
    }

    public boolean subsumes(int superType, int type) {
        return this.ll_subsumes(superType, type);
    }

    private boolean ll_isPrimitiveArrayType(int type) {
        return type == this.floatArrayTypeCode || type == this.intArrayTypeCode || type == this.booleanArrayTypeCode || type == this.shortArrayTypeCode || type == this.byteArrayTypeCode || type == this.longArrayTypeCode || type == this.doubleArrayTypeCode || type == this.stringArrayTypeCode;
    }

    @Override
    public boolean ll_subsumes(int superType, int type) {
        if (superType == type) {
            return true;
        }
        if (superType == this.fsArrayTypeCode) {
            return !this.ll_isPrimitiveArrayType(type) && this.ll_isArrayType(type);
        }
        if (type == this.fsArrayTypeCode) {
            return superType == this.top || superType == this.arrayBaseTypeCode || !this.ll_isPrimitiveArrayType(superType) && this.ll_isArrayType(superType);
        }
        boolean isSuperArray = this.ll_isArrayType(superType);
        boolean isSubArray = this.ll_isArrayType(type);
        if (isSuperArray) {
            if (isSubArray) {
                return this.ll_subsumes(this.ll_getComponentType(superType), this.ll_getComponentType(type));
            }
            return false;
        }
        if (isSubArray) {
            return superType == this.top || superType == this.arrayBaseTypeCode;
        }
        return this.subsumes.get(superType).get(type);
    }

    private void updateSubsumption(int type, int superType) {
        int max = this.typeNameST.size();
        for (int i = 1; i <= max; ++i) {
            if (!this.subsumes(i, superType)) continue;
            this.addSubsubsumption(i, type);
        }
        this.addSubsubsumption(type, type);
    }

    private void addSubsubsumption(int superType, int type) {
        this.subsumes.get(superType).set(type);
    }

    private void newType() {
        this.tree.add(new IntVector());
        this.subsumes.add(new BitSet());
        this.approp.add(new IntVector());
    }

    SymbolTable getTypeNameST() {
        return this.typeNameST;
    }

    private final String getTypeString(Type t) {
        return t.getName() + " (" + this.ll_getCodeForType(t) + ")";
    }

    private final String getFeatureString(Feature f) {
        return f.getName() + " (" + this.ll_getCodeForFeature(f) + ")";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("~" + this.getTypeString(this.getTopType()) + ";\n");
        int numTypes = this.typeNameST.size();
        for (int i = 2; i <= numTypes; ++i) {
            Type t = this.ll_getTypeForCode(i);
            buf.append(this.getTypeString(t) + " < " + this.getTypeString(this.getParent(t)) + ";\n");
        }
        int numFeats = this.featureNameST.size();
        for (int i = 1; i <= numFeats; ++i) {
            Feature f = this.ll_getFeatureForCode(i);
            buf.append(this.getFeatureString(f) + ": " + this.getTypeString(f.getDomain()) + " > " + this.getTypeString(f.getRange()) + ";\n");
        }
        return buf.toString();
    }

    @Override
    public void commit() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        this.numCommittedTypes = this.types.size();
        this.casMetadata.setupFeaturesAndCreatableTypes();
    }

    @Override
    public boolean isCommitted() {
        return this.locked;
    }

    @Deprecated
    public Feature getFeature(String featureName) {
        return this.getFeatureByFullName(featureName);
    }

    @Override
    public void setFeatureFinal(Type type) {
        ((TypeImpl)type).setFeatureFinal();
    }

    @Override
    public void setInheritanceFinal(Type type) {
        ((TypeImpl)type).setInheritanceFinal();
    }

    @Override
    public Type addStringSubtype(String typeName, String[] stringList) throws CASAdminException {
        TypeImpl mother = this.stringType;
        this.checkTypeSyntax(typeName);
        int typeCode = this.addType(typeName, mother.getCode(), true);
        if (typeCode < this.typeNameST.getStart()) {
            return null;
        }
        StringTypeImpl type = (StringTypeImpl)this.types.get(typeCode);
        type.setFeatureFinal();
        type.setInheritanceFinal();
        Arrays.sort(stringList);
        this.stringSets.add(stringList);
        return type;
    }

    public String[] getStringSet(int i) {
        return this.stringSets.get(i);
    }

    @Override
    public TypeNameSpace getTypeNameSpace(String name) {
        if (!TypeSystemUtils.isTypeNameSpaceName(name)) {
            return null;
        }
        return new TypeNameSpaceImpl(name, this);
    }

    @Override
    public int ll_getCodeForTypeName(String typeName) {
        if (typeName == null) {
            throw new NullPointerException();
        }
        return this.typeNameST.get(typeName);
    }

    @Override
    public int ll_getCodeForType(Type type) {
        return ((TypeImpl)type).getCode();
    }

    @Override
    public int ll_getCodeForFeatureName(String featureName) {
        if (featureName == null) {
            throw new NullPointerException();
        }
        if (!this.featureMap.containsKey(featureName)) {
            return 0;
        }
        return this.featureMap.get(featureName);
    }

    @Override
    public int ll_getCodeForFeature(Feature feature) {
        return ((FeatureImpl)feature).getCode();
    }

    @Override
    public Type ll_getTypeForCode(int typeCode) {
        if (this.isType(typeCode)) {
            return this.types.get(typeCode);
        }
        return null;
    }

    private final int getLargestFeatureCode() {
        return this.getNumberOfFeatures();
    }

    final boolean isFeature(int featureCode) {
        return featureCode > 0 && featureCode <= this.getLargestFeatureCode();
    }

    @Override
    public Feature ll_getFeatureForCode(int featureCode) {
        if (this.isFeature(featureCode)) {
            return this.features.get(featureCode);
        }
        return null;
    }

    @Override
    public int ll_getDomainType(int featureCode) {
        return this.intro(featureCode);
    }

    @Override
    public int ll_getRangeType(int featureCode) {
        return this.range(featureCode);
    }

    @Override
    public LowLevelTypeSystem getLowLevelTypeSystem() {
        return this;
    }

    @Override
    public boolean ll_isStringSubtype(int type) {
        return this.stringSetMap.containsKey(type);
    }

    @Override
    public boolean ll_isRefType(int typeCode) {
        int typeClass = this.ll_getTypeClass(typeCode);
        switch (typeClass) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Type getArrayType(Type componentType) {
        int arrayTypeCode = this.ll_getArrayType(this.ll_getCodeForType(componentType));
        if (arrayTypeCode == 0) {
            return null;
        }
        return this.types.get(arrayTypeCode);
    }

    @Override
    public final int ll_getTypeClass(int typeCode) {
        if (typeCode == this.booleanTypeCode) {
            return 9;
        }
        if (typeCode == this.byteTypeCode) {
            return 10;
        }
        if (typeCode == this.shortTypeCode) {
            return 11;
        }
        if (typeCode == this.intTypeCode) {
            return 1;
        }
        if (typeCode == this.floatTypeCode) {
            return 2;
        }
        if (typeCode == this.longTypeCode) {
            return 12;
        }
        if (typeCode == this.doubleTypeCode) {
            return 13;
        }
        if (this.stringTypeCode != 0 && this.ll_subsumes(this.stringTypeCode, typeCode)) {
            return 3;
        }
        if (typeCode == this.booleanArrayTypeCode) {
            return 14;
        }
        if (typeCode == this.byteArrayTypeCode) {
            return 15;
        }
        if (typeCode == this.shortArrayTypeCode) {
            return 16;
        }
        if (typeCode == this.intArrayTypeCode) {
            return 4;
        }
        if (typeCode == this.floatArrayTypeCode) {
            return 5;
        }
        if (typeCode == this.longArrayTypeCode) {
            return 17;
        }
        if (typeCode == this.doubleArrayTypeCode) {
            return 18;
        }
        if (typeCode == this.stringArrayTypeCode) {
            return 6;
        }
        if (this.ll_isArrayType(typeCode)) {
            return 7;
        }
        return 8;
    }

    @Override
    public int ll_getArrayType(int componentTypeCode) {
        if (this.componentToArrayTypeMap.containsKey(componentTypeCode)) {
            return this.componentToArrayTypeMap.get(componentTypeCode);
        }
        return this.addArrayType(this.ll_getTypeForCode(componentTypeCode), this.ll_getTypeForCode(this.ll_computeArrayParentFromComponentType(componentTypeCode)));
    }

    int addArrayType(Type componentType, Type mother) {
        return this.ll_addArrayType(this.ll_getCodeForType(componentType), this.ll_getCodeForType(mother));
    }

    int ll_addArrayType(int componentTypeCode, int motherCode) {
        if (!this.ll_isValidTypeCode(componentTypeCode)) {
            return 0;
        }
        String arrayTypeName = TypeSystemImpl.getArrayTypeName(this.ll_getTypeForCode(componentTypeCode).getName());
        int arrayTypeCode = this.typeNameST.set(arrayTypeName);
        this.componentToArrayTypeMap.put(componentTypeCode, arrayTypeCode);
        this.arrayToComponentTypeMap.put(arrayTypeCode, componentTypeCode);
        this.newType();
        TypeImpl arrayType = new TypeImpl(arrayTypeName, arrayTypeCode, this);
        this.types.add(arrayType);
        this.parents.add(motherCode);
        if (!this.isCommitted()) {
            this.numCommittedTypes = this.types.size();
        }
        this.arrayCodeToTypeMap.put(arrayTypeCode, arrayType);
        if (!this.isCommitted() && motherCode != this.fsArrayTypeCode) {
            int arrayBaseTypeCodeBeforeCommitted = this.arrayBaseTypeCode;
            this.tree.get(arrayBaseTypeCodeBeforeCommitted).add(arrayTypeCode);
            this.updateSubsumption(arrayTypeCode, this.arrayBaseTypeCode);
        }
        return arrayTypeCode;
    }

    @Override
    public boolean ll_isValidTypeCode(int typeCode) {
        return this.typeNameST.getSymbol(typeCode) != null || this.arrayToComponentTypeMap.containsKey(typeCode);
    }

    @Override
    public boolean ll_isArrayType(int typeCode) {
        return this.arrayCodeToTypeMap.containsKey(typeCode);
    }

    @Override
    public int ll_getComponentType(int arrayTypeCode) {
        if (this.ll_isArrayType(arrayTypeCode)) {
            return this.arrayToComponentTypeMap.get(arrayTypeCode);
        }
        return 0;
    }

    @Override
    public boolean ll_isPrimitiveType(int typeCode) {
        return !this.ll_isRefType(typeCode);
    }

    @Override
    public String[] ll_getStringSet(int typeCode) {
        if (!this.ll_isStringSubtype(typeCode)) {
            return null;
        }
        return this.stringSets.get(this.stringSetMap.get(typeCode));
    }

    static {
        arrayComponentTypeNameMap.put("uima.cas.TOP", "uima.cas.FSArray");
        arrayComponentTypeNameMap.put("uima.cas.Boolean", "uima.cas.BooleanArray");
        arrayComponentTypeNameMap.put("uima.cas.Byte", "uima.cas.ByteArray");
        arrayComponentTypeNameMap.put("uima.cas.Short", "uima.cas.ShortArray");
        arrayComponentTypeNameMap.put("uima.cas.Integer", "uima.cas.IntegerArray");
        arrayComponentTypeNameMap.put("uima.cas.Float", "uima.cas.FloatArray");
        arrayComponentTypeNameMap.put("uima.cas.Long", "uima.cas.LongArray");
        arrayComponentTypeNameMap.put("uima.cas.Double", "uima.cas.DoubleArray");
        arrayComponentTypeNameMap.put("uima.cas.String", "uima.cas.StringArray");
        arrayTypeComponentNameMap.put("uima.cas.FSArray", "uima.cas.TOP");
        arrayTypeComponentNameMap.put("uima.cas.BooleanArray", "uima.cas.Boolean");
        arrayTypeComponentNameMap.put("uima.cas.ByteArray", "uima.cas.Byte");
        arrayTypeComponentNameMap.put("uima.cas.ShortArray", "uima.cas.Short");
        arrayTypeComponentNameMap.put("uima.cas.IntegerArray", "uima.cas.Integer");
        arrayTypeComponentNameMap.put("uima.cas.FloatArray", "uima.cas.Float");
        arrayTypeComponentNameMap.put("uima.cas.LongArray", "uima.cas.Long");
        arrayTypeComponentNameMap.put("uima.cas.DoubleArray", "uima.cas.Double");
        arrayTypeComponentNameMap.put("uima.cas.StringArray", "uima.cas.String");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private final int len;
        private int pos = 0;

        private ListIterator(List<T> list, int max) {
            this.list = list;
            this.len = max < list.size() ? max : list.size();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.len;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T o = this.list.get(this.pos);
            ++this.pos;
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

