/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XMLUtils {
    public static void normalize(String aStr, StringBuffer aResultBuf) {
        XMLUtils.normalize(aStr, aResultBuf, false);
    }

    public static void normalize(String aStr, StringBuffer aResultBuf, boolean aNewlinesToSpaces) {
        if (aStr != null) {
            int len = aStr.length();
            block8: for (int i = 0; i < len; ++i) {
                char c = aStr.charAt(i);
                if (c > '\u007f') {
                    aResultBuf.append("&#").append((int)c).append(';');
                    continue;
                }
                switch (c) {
                    case '<': {
                        aResultBuf.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        aResultBuf.append("&gt;");
                        continue block8;
                    }
                    case '&': {
                        aResultBuf.append("&amp;");
                        continue block8;
                    }
                    case '\"': {
                        aResultBuf.append("&quot;");
                        continue block8;
                    }
                    case '\n': {
                        aResultBuf.append(aNewlinesToSpaces ? " " : "\n");
                        continue block8;
                    }
                    case '\r': {
                        aResultBuf.append(aNewlinesToSpaces ? " " : "\r");
                        continue block8;
                    }
                    default: {
                        aResultBuf.append(c);
                    }
                }
            }
        }
    }

    public static void writeNormalizedString(String aStr, Writer aWriter, boolean aNewlinesToSpaces) throws IOException {
        if (aStr == null) {
            return;
        }
        int len = aStr.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = aStr.charAt(i);
            switch (c) {
                case '<': {
                    aWriter.write("&lt;");
                    continue block8;
                }
                case '>': {
                    aWriter.write("&gt;");
                    continue block8;
                }
                case '&': {
                    aWriter.write("&amp;");
                    continue block8;
                }
                case '\"': {
                    aWriter.write("&quot;");
                    continue block8;
                }
                case '\n': {
                    aWriter.write(aNewlinesToSpaces ? " " : "\n");
                    continue block8;
                }
                case '\r': {
                    aWriter.write(aNewlinesToSpaces ? " " : "\r");
                    continue block8;
                }
                default: {
                    aWriter.write(c);
                }
            }
        }
    }

    public static void writePrimitiveValue(Object aObj, Writer aWriter) throws IOException {
        String className = aObj.getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex > -1) {
            className = className.substring(lastDotIndex + 1).toLowerCase();
        }
        aWriter.write("<");
        aWriter.write(className);
        aWriter.write(">");
        XMLUtils.writeNormalizedString(aObj.toString(), aWriter, true);
        aWriter.write("</");
        aWriter.write(className);
        aWriter.write(">");
    }

    public static void writePrimitiveValue(Object aObj, ContentHandler aContentHandler) throws SAXException {
        AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
        String className = aObj.getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex > -1) {
            className = className.substring(lastDotIndex + 1).toLowerCase();
        }
        aContentHandler.startElement(null, className, className, EMPTY_ATTRIBUTES);
        String valStr = aObj.toString();
        aContentHandler.characters(valStr.toCharArray(), 0, valStr.length());
        aContentHandler.endElement(null, className, className);
    }

    public static Element getChildByTagName(Element aElem, String aName) {
        NodeList matches = aElem.getElementsByTagName(aName);
        for (int i = 0; i < matches.getLength(); ++i) {
            Element childElem = (Element)matches.item(i);
            if (childElem.getParentNode() != aElem) continue;
            return childElem;
        }
        return null;
    }

    public static Element getFirstChildElement(Element aElem) {
        NodeList children = aElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = children.item(i);
            if (!(curNode instanceof Element)) continue;
            return (Element)curNode;
        }
        return null;
    }

    public static Object readPrimitiveValue(Element aElem) {
        String tagName = aElem.getTagName();
        if (tagName.endsWith("_p")) {
            tagName = tagName.substring(0, tagName.lastIndexOf("_p"));
        }
        char[] chars = tagName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String className = "java.lang." + new String(chars);
        String stringifiedObject = XMLUtils.getText(aElem, true);
        try {
            Class<?> theClass = Class.forName(className);
            Constructor<?> constructor = theClass.getConstructor(String.class);
            return constructor.newInstance(stringifiedObject);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getText(Element aElem) {
        StringBuffer buf = new StringBuffer();
        NodeList children = aElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = children.item(i);
            if (curNode instanceof Text) {
                buf.append(((Text)curNode).getData());
                continue;
            }
            if (!(curNode instanceof Element)) continue;
            buf.append('<').append(((Element)curNode).getTagName()).append('>');
            buf.append(XMLUtils.getText((Element)curNode));
            buf.append("</").append(((Element)curNode).getTagName()).append('>');
        }
        return buf.toString().trim();
    }

    public static String getText(Element aElem, boolean aExpandEnvVarRefs) {
        StringBuffer buf = new StringBuffer();
        NodeList children = aElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node curNode = children.item(i);
            if (curNode instanceof Text) {
                buf.append(((Text)curNode).getData());
                continue;
            }
            if (!(curNode instanceof Element)) continue;
            Element subElem = (Element)curNode;
            if (aExpandEnvVarRefs && "envVarRef".equals(subElem.getTagName())) {
                String varName = XMLUtils.getText(subElem, false);
                String value = System.getProperty(varName);
                if (value == null) continue;
                buf.append(value);
                continue;
            }
            buf.append('<').append(((Element)curNode).getTagName()).append('>');
            buf.append(XMLUtils.getText((Element)curNode, aExpandEnvVarRefs));
            buf.append("</").append(((Element)curNode).getTagName()).append('>');
        }
        return buf.toString().trim();
    }

    public static final int checkForNonXmlCharacters(String s) {
        return XMLUtils.checkForNonXmlCharacters(s, false);
    }

    public static final int checkForNonXmlCharacters(String s, boolean xml11) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < s.length(); ++i) {
            char cNext;
            int iNext;
            char c = s.charAt(i);
            if (XMLUtils.isValidXmlUtf16int(c, xml11)) continue;
            if (c >= '\ud800' && c <= '\udbff' && (iNext = i + 1) < s.length() && (cNext = s.charAt(iNext)) >= '\udc00' && cNext <= '\udfff') {
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    public static final int checkForNonXmlCharacters(char[] ch, int start, int length, boolean xml11) {
        if (ch == null) {
            return -1;
        }
        for (int i = start; i < start + length; ++i) {
            char cNext;
            int iNext;
            char c = ch[i];
            if (XMLUtils.isValidXmlUtf16int(c, xml11)) continue;
            if (c >= '\ud800' && c <= '\udbff' && (iNext = i + 1) < start + length && (cNext = ch[iNext]) >= '\udc00' && cNext <= '\udfff') {
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    private static final boolean isValidXmlUtf16int(char c, boolean xml11) {
        if (xml11) {
            return c >= '\u0001' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
        }
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }
}

