# Results

## Model verification
The models were created in different formats such as SBMLqual, SIF, and BNET, aiming to facilitate analysis with different tools. Analysis of the models' structural and dynamic properties was used to verify their accuracy. We calculated the basic topological features by determining model components, in/out degrees, and interaction directionality. As part of the network analysis, centrality measures were estimated to evaluate the importance of biomolecules from a network perspective. These measures show the degree to which a biomolecule can influence the flow of information in a model. For dynamic verification, the construction of BFs represented the original interactions and followed the construction rules of the CaSQ tool. The sensitivity analysis against single small perturbations (knockouts and overexpressions) proved the stability of the BFs and model robustness. 
- Structural verification
  - Topological analysis
The topological analysis offers i) a general assessment of model size, identifying their completeness and reduction, and ii) specific identification of the key biomolecules that keep information flowing during simulations of Boolean models. As a result of applying CaSQ rules, the inferred models are reduced to an activity flow representation, which displays the direct interactions between the biomolecules (activation and inhibition). The reduction percent varies according to model structure and complexity.The topology of biomolecules represents their importance from a network perspective, showing the degree to which a biomolecule could influence the flow of information in a model. This information was used to verify model dynamics by perturbing these significant topologies 
     - [Topological summary](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/blob/main/Results/topological%20analysis/topological_analysis.csv) - [dopamine transcription](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis)- [FOXO3 activity](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis)- [mTOR](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis) - [wnt-pi3k/akt signalling](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis) - [ppargc1a signalling](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis) - [PRKN mitophagy](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis) - [TCA](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/topological%20analysis)
- Dynamic verification

This analysis quantified the sensitivity of the models in response to all possible single knockouts and overexpressions. Two sets of attractors (original and perturbed) were identified as an ordered list of model states. The identity and similarity between the original and perturbed attractors are identified by calculating the Hamming distance. Thus, the identity-based distance indicates whether the unperturbed and perturbed attractors are identical. A similarity-based distance represents the minimum difference between a state sequence in the unperturbed and perturbed attractors. We observed that all models were less sensitive to knockouts than to overexpressions. 
  - Sensitivity analysis
     - [summary_knockouts](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/blob/main/Results/sensitivities%20against%20mutations/summary_-_knockouts.csv) - [summary_overexpression](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/blob/main/Results/sensitivities%20against%20mutations/summary_-_overexpressions.csv)- [dopamine transcription](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations) - [FOXO3 activity](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations) - [mTOR](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations)  - [wnt-pi3k/akt signalling](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations)- [ppargc1a signalling](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations) - [PRKN mitophagy](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations) - [TCA](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/sensitivities%20against%20mutations)
  - Attractor reachability
The results of an attractor analysis indicated that state trajectories converge to fixed or cyclic attractors in the course of different updating schemes. The transitions between states in a synchronous scheme were calculated from each possible state until the attractor was reached. The SAT solver algorithm improved the speed of attractor reachability by reducing the initial size of the states. In comparison to the SAT solver-based method, the decomposition method performed faster for the detection of attractor patterns. As a result of this approach, the model was split into strongly connected components (SCCs) which reduced the complexity of the model. However, we noticed that the number of attractors reached was less than the number reached by the SAT-solver algorithm. 
      - [dopamine transcription](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/dopamine%20transcription%20pathway) - [FOXO3 activity](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/foxo3%20activity)  - [mTOR](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/mtor) - [wnt-pi3k/akt signalling](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/pi3kakt) - [ppargc1a signalling](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/ppargc1a) - [PRKN mitophagy](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/prkn%20mitophagy%20pathway)  - [TCA](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/steady%20states%20calculations/tca)


## Cohort specific Boolean simulation
The miRNA-target enrichment analysis identified significant pathways including dopamine transcription signalling, FOXO3 activity, mTOR-MAPK signalling, PRKN mitophagy, and WNT-PI3K/AKT signalling.
- [Conditions probabilities](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/probabilistic%20boolean%20simulations/conditions%20probabilities)
      - [Dynamic time wrapping scores](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/probabilistic%20boolean%20simulations/dynamic%20time%20wrapping%20scores)
      - [Trajectories probabilities](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/probabilistic%20boolean%20simulations/trajectories%20probabilities)
      - [Entropy and transition entropy](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/probabilistic%20boolean%20simulations/raw%20results)
      - [Figures](https://gitlab.lcsb.uni.lu/Ahmed7emdan/applications-of-boolean-modelling-to-study-and-stratify-dynamics-of-a-complex-disease/-/tree/main/Results/probabilistic%20boolean%20simulations/figures)
