##phenotype Th1Th2iTreg -> coexpressed Tbet-Foxp3-ROR??t
###minimum input composition TCR + IFN?? / IL12 / IL27 + IL4 + TGF??
###maximum input composition TCR + IFN-?? + IL-12 + IL-18 + IL-23 + IL-27 + IL-4 + TGF-??
net_Th1Th2iTreg_minimum <- fixGenes(network, c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "TGFb", "RORgt", "STAT5", 
                                               "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                               "Tbet", "STAT6", "IL6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                               "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"), 
                                    c(1,-1,1,-1,-1,-1,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0))

net_Th1Th2iTreg_maximum <- fixGenes(network, c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "TGFb", "RORgt", "STAT5", 
                                               "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                               "Tbet", "STAT6", "IL6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                               "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"), 
                                    c(1,1,1,-1,-1,-1,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0))


sim_Th1Th2iTreg_minimum <- markovSimulation(net_Th1Th2iTreg_minimum,
                                            numIterations = 1000,
                                            startStates = c("TCR","IL12","IL27","IFNg","TGFb","IL4")
                                            cutoff = 0.001,
                                            returnTable = TRUE)

#Retrieves the state transitions and their probabilities in a PBN.
#This takes the transition table information calculated by the markovSimulation method

transPBN_Th1Th2iTregmini <- (getTransitionProbabilities(sim_Th1Th2iTreg_minimum))
plotPBNTransitions(sim_Th1iTreg_minimum,
                   drawProbabilities = TRUE, 
                   drawStateLabels = TRUE, 
                   plotIt = TRUE)

sim_Th1Th2iTreg_maximum<- markovSimulation(net_Th1Th2iTreg_maximum,
                                           numIterations = 100,
                                           startStates = c("TCR","IL12","IL27","IFNg","TGFb","IL4"),
                                           cutoff = 0.001,
                                           returnTable = TRUE)
transPBN_Th1Th2iTregmini <- (getTransitionProbabilities(sim_Th1Th2iTreg_minimum))
plotPBNTransitions(sim_Th1Th2iTreg_minimum,
                   drawProbabilities = TRUE, 
                   drawStateLabels = TRUE, 
                   plotIt = TRUE)


###Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous
attr_sync_Th1Th2iTreg <- getAttractors(network, method="chosen",startStates=list(rep(7,38)))

plotAttractors(attr_sync_Th1Th2iTreg,
               title = "Synchronous scheme attractors",
               mode = c("table","graph"),
               plotFixed = TRUE,
               onColor = "#4daf4a",
               offColor = "#e41a1c",
               drawLabels = TRUE,
               drawLegend = TRUE,
               borderColor = "black",eps = 0.1,
               allInOnePlot = FALSE)
###Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous

ATT_Th1Th2iTreg <- getAttractors(network,
                                 type = c("asynchronous"),
                                 method = c("random"),
                                 startStates = 500,
                                 genesON = c("TCR","IL12","IL27","IFNg","TGFb"), 
                                 genesOFF = c("IL23", "IL4_e", "IL6_e", "IFNg_e", "IL18", "RORgt", "STAT5", 
                                              "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                              "Tbet", "STAT6", "IL6", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                              "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"),
                                 randomChainLength = 10000,
                                 avoidSelfLoops = TRUE,
                                 geneProbabilities = NULL,
                                 maxAttractorLength = Inf,
                                 returnTable = TRUE)
plotAttractors(ATT_Th1Th2iTreg,
               title = "A Synchronous scheme attractors",
               mode = c("table","graph"),
               plotFixed = TRUE,
               onColor = "#4daf4a",
               offColor = "#e41a1c",
               drawLabels = TRUE,
               drawLegend = TRUE,
               ask = TRUE,
               reverse = FALSE,
               borderColor = "black",eps = 0.1,
               allInOnePlot = FALSE)