### This code is to analyse the Cytokine Composition complexitiy
### as inputs at minmum and maximum states
### then find attractors with Markov simulation, 
### synchronous and asynchronous schemes and relate them to new phenotypes
### On 3th March 2020, by Ahmed Hemedan
library(BoolNet)
library(igraph)
file <- ("./tcell.sbml") 
#Loads an SBML document that specifies a qualitative model using the sbml-qual extension package.
network <- loadSBML(file, symbolic=FALSE)

#Identify important states in probabilistic Boolean networks (PBN) using a Markov chain simulation Usage


##minimum inputs TCR + IL-4 
##maximum inputs TCR + IL-18+IL-27+IFN-??+IL-4+IL-6+IL-23
#fix genes for markov simulation

net_th2_minimum <- fixGenes(network, c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "TGFb", "RORgt", "STAT5", 
                                       "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                       "Tbet", "STAT6", "IL6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                       "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"), 
                            c(-1,-1,-1,-1,-1,-1,-1,1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0))

net_th2_maximum <- fixGenes(network, c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "TGFb", "RORgt", "STAT5", 
                                       "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                       "Tbet", "STAT6", "IL6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                       "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"), 
                            c(-1,1,1,-1,-1,-1,1,1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0))
#phenotype Th2 -> coexpressed GATA3
sim_th2_minimum <- markovSimulation(net_th2_minimum ,
                        numIterations = 1000,
                        startStates = c("TCR","IL4"),
                        cutoff = 0.001,
                        returnTable = TRUE)
#Retrieves the state transitions and their probabilities in a PBN.
#This takes the transition table information calculated by the markovSimulation method
transPBN_th2_mini <- (getTransitionProbabilities(sim_th2_minimum))
plotPBNTransitions(sim_th2_minimum,
                   drawProbabilities = TRUE, 
                   drawStateLabels = TRUE, 
                   plotIt = TRUE)

sim_th2_maximum <- markovSimulation(net_th2_maximum,
                                    numIterations = 1000,
                                    startStates = c("IL23", "IL27","IL18", "TCR","IL6", "IFNg","IL4"),
                                    cutoff = 0.001,
                                    returnTable = TRUE)
#Retrieves the state transitions and their probabilities in a PBN.
#This takes the transition table information calculated by the markovSimulation method
transPBN_th2max <- (getTransitionProbabilities(sim_th2_maximum))
plotPBNTransitions(sim_th2_maximum,
                   drawProbabilities = TRUE, 
                   drawStateLabels = TRUE, 
                   plotIt = TRUE)

###Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous

attr_sync_th2 <- getAttractors(network, method="chosen",startStates=list(rep(7,38)))

plotAttractors(attr_sync_th2,
               title = "Synchronous scheme attractors",
               mode = c("table","graph"),
               plotFixed = TRUE,
               onColor = "#4daf4a",
               offColor = "#e41a1c",
               drawLabels = TRUE,
               drawLegend = TRUE,
               borderColor = "black",eps = 0.1,
               allInOnePlot = FALSE)
###Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous
ATT_th2 <- getAttractors(network,
                    type = c("asynchronous"),
                    method = c("random"),
                    startStates = 200,
                    genesON = c("IL4","TCR"), 
                    genesOFF = c("Foxp3", "GATA3", "IFNg","IFNgR","IL12R","IL17","IL18R","IL2",
                                 "IL21","IL21R", "IL23R","IL2R","IL4R","IL6","IL6R","IRAK",
                                 "Jak1","NFAT","NFkB","RORgt","SOCS1", "STAT1","STAT3",'STAT4', 
                                 'STAT5','STAT6','Tbet'),
                    canonical = TRUE,
                    randomChainLength = 10000,
                    avoidSelfLoops = TRUE,
                    geneProbabilities = NULL,
                    maxAttractorLength = Inf,
                    returnTable = TRUE)
plotAttractors(ATT_th2,
               subset = c(6,7),
               title = "A Synchronous scheme attractors",
               mode = c("table","graph"),
               plotFixed = TRUE,
               onColor = "#4daf4a",
               offColor = "#e41a1c",
               layout = layout.circle,
               drawLabels = TRUE,
               drawLegend = TRUE,
               ask = TRUE,
               reverse = FALSE,
               borderColor = "black",eps = 0.1,
               allInOnePlot = FALSE)

















#

