##phenotype Th17-iTreg -> coexpressed Foxp3-ROR??t
###minimum input composition TCR + TGF-?? + IL-6
###maximum input composition TCR + TGF-?? + IL-6 + IL-18 + IL-23


net_Th17iTreg_minimum <- fixGenes(network, c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "TGFb", "RORgt", "STAT5", 
                                             "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                             "Tbet", "STAT6", "IL6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                             "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"), 
                                  c(-1,-1,-1,-1,-1,-1,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0))

net_Th17iTreg_maximum <- fixGenes(network, c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "TGFb", "RORgt", "STAT5", 
                                             "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                             "Tbet", "STAT6", "IL6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                             "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"), 
                                  c(-1,1,-1,-1,-1,-1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0))


sim_net_Th17iTreg_minimum <- markovSimulation(net_Th17iTreg_minimum,
                                              numIterations = 1000,
                                              startStates = c("TCR","TGFb","IL6"),
                                              cutoff = 0.001,
                                              returnTable = TRUE)

#Retrieves the state transitions and their probabilities in a PBN.
#This takes the transition table information calculated by the markovSimulation method

transPBN_Th17iTregmini <- (getTransitionProbabilities(sim_th1_minimum))
plotPBNTransitions(net_Th17iTreg_minimum,
                   drawProbabilities = TRUE, 
                   drawStateLabels = TRUE, 
                   plotIt = TRUE)

sim_Th17iTreg_maximum <- markovSimulation(net_Th17iTreg_maximum,
                                          numIterations = 1000,
                                          startStates = c("TCR","TGFb","IL23","IL18","IL6"),
                                          cutoff = 0.001,
                                          returnTable = TRUE)
transPBN_Th17iTregmax <- (getTransitionProbabilities(sim_th1_minimum))
plotPBNTransitions(sim_iTreg_maximum,
                   drawProbabilities = TRUE, 
                   drawStateLabels = TRUE, 
                   plotIt = TRUE)


###Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous
attr_sync_Th17iTreg <- getAttractors(network, method="chosen",startStates=list(rep(7,38)))

plotAttractors(attr_sync_Th17iTreg ,
               title = "Synchronous scheme attractors",
               mode = c("table","graph"),
               plotFixed = TRUE,
               onColor = "#4daf4a",
               offColor = "#e41a1c",
               drawLabels = TRUE,
               drawLegend = TRUE,
               borderColor = "black",eps = 0.1,
               allInOnePlot = FALSE)
###Identifies attractors (cycles) in a supplied Boolean network using synchronous or asynchronous

ATT_Th17iTreg <- getAttractors(network,
                               type = c("asynchronous"),
                               method = c("random"),
                               startStates = 500,
                               genesON = c("TCR","TGFb","IL6"), 
                               genesOFF = c("IL12","IL23", "IL27", "IL4_e", "IL6_e", "IFNg_e", "IL18", "TCR", "RORgt", "STAT5", 
                                            "TGFbR", "IL23R", "IL18R", "Jak1", "IL17", "IL2R", "IL2", "IL4R", "NFAT", "STAT4", "STAT3", 
                                            "Tbet", "STAT6", "IFNg", "IL21", "Foxp3", "IL6R", "STAT1", "IL4", "IL21R", "IRAK", 
                                            "GATA3", "IL12R", "SOCS1", "NFkB", "IFNgR"),
                               randomChainLength = 10000,
                               avoidSelfLoops = TRUE,
                               geneProbabilities = NULL,
                               maxAttractorLength = Inf,
                               returnTable = TRUE)
plotAttractors(ATT_Th17iTreg,
               subset = c(6,7),
               title = "A Synchronous scheme attractors",
               mode = c("table","graph"),
               plotFixed = TRUE,
               onColor = "#4daf4a",
               offColor = "#e41a1c",
               layout = layout.circle,
               drawLabels = TRUE,
               drawLegend = TRUE,
               ask = TRUE,
               reverse = FALSE,
               borderColor = "black",eps = 0.1,
               allInOnePlot = FALSE)
