################################################################################
##Genome-wide association study of copy number variations in Parkinson's disease
################################################################################

library(dplyr)
library(ggplot2)

##################################################
##3.Miami Plot 
##################################################

##Input rCNV2 summary statistics for deletion
glm_file_DEL <- read.table("fisher_courage_filtered_20SNP_len20kb_DEL", header = T)
glm_file_DEL$P <- as.numeric(10^-(glm_file_DEL$fisher_neg_log10_p))
glm_file_DEL$ID <- paste0(glm_file_DEL$chr,"_",glm_file_DEL$start)

##Input rCNV2 summary statistics for duplication
glm_file_DUP <- read.table("fisher_courage_filtered_20SNP_len20kb_DUP", header = T)
glm_file_DUP$P <- as.numeric(10^-(glm_file_DUP$fisher_neg_log10_p))
glm_file_DUP$ID <- paste0(glm_file_DUP$chr,"_",glm_file_DUP$start)

tiff("miami.tiff", width=1800, height=1000, res = 100)
par(mfrow=c(2,1))
par(mar=c(0,5,3,3))
qqman::manhattan(glm_file_DEL,chr="chr",bp="start",p="P",snp="ID", main = "", ylim = c(0,25),cex = 1.25, cex.axis = 1.5, cex.lab = 2, ylab = "-log10(p) DEL",
                 las=2, font = 4, col = c("darkblue", "darkgrey"), genomewideline = F,
                 suggestiveline = -log10(3.74e-06))
par(mar=c(5,5,3,3))
qqman::manhattan(glm_file_DUP,chr="chr",bp="start",p="P",snp="ID", main = "", ylim = c(25,0),cex = 1.25, cex.axis = 1.5, cex.lab = 2, ylab = "-log10(p) DUP",
                 las=2, font = 4, col = c("darkblue", "darkgrey"), genomewideline = F,
                 suggestiveline = -log10(3.74e-06) ,xlab="",xaxt="n")
dev.off()
