################################################################################
##Genome-wide association study of copy number variations in Parkinson's disease
################################################################################

library(enrichR)
library(dplyr)
library(ggplot2)

##################################################
##6. Enrichment analysis
##################################################

setEnrichrSite("Enrichr") # Human genes
websiteLive <- TRUE
dbs <- listEnrichrDbs()

#####################################
dbs <- c("GO_Molecular_Function_2023", "GO_Cellular_Component_2023", "GO_Biological_Process_2023")

# input the list of CNV verlapping genes
gene <- readxl::read_xlsx("CNV_genes.xlsx")

enriched_up <- enrichr(gene, dbs)

##GO
enriched_up_MF <- as.data.frame(enriched_up$GO_Molecular_Function_2023)
enriched_up_CC <- as.data.frame(enriched_up$GO_Cellular_Component_2023)
enriched_up_BP <- as.data.frame(enriched_up$GO_Biological_Process_2023)
enriched_up_DF <- rbind(enriched_up_BP, enriched_up_CC, enriched_up_MF)
rm(enriched_up_BP, enriched_up_CC, enriched_up_MF)
enriched_up_DF <- arrange(enriched_up_DF, enriched_up_DF$Overlap)

plotEnrich(enriched_up_DF, showTerms = 10, y = "Count", orderBy = "Overlap")

##KEGG
dbs <- c("KEGG_2021_Human")
enriched_kegg <- enrichr(gene, dbs)
plotEnrich(enriched_kegg[[1]], showTerms = 10, y = "Count", orderBy = "P.value")

##Reactome
dbs <- c("Reactome_2022")
enriched_reactome <- enrichr(gene, dbs)
plotEnrich(enriched_reactome[[1]], showTerms = 10, y = "Count", orderBy = "P.value")

##DisGeNET
dbs <- c("DisGeNET")
enriched_DisGeNET <- enrichr(gene, dbs)
plotEnrich(enriched_DisGeNET[[1]], showTerms = 10, y = "Count", orderBy = "P.value")

