library(dplyr)
library(MuSiC)
library(Biobase)
library(pheatmap)

#R script of figure 4E (week 8) and figure S3 (week 10-11)

#Input Bulk rna seq
load("data_Patricia/feature_counts_katja_2022.RData")
count_data <- as.data.frame(fc$counts)
#prepare meta_data
pheno_data <- as.data.frame(readxl::read_xlsx("data_Patricia/pheno_matrix.xlsx"))
rownames(pheno_data) <- pheno_data$SampleID
#Format Bulk data
metadata <- data.frame(labelDescription= colnames(pheno_data), row.names=colnames(pheno_data))
BULK.eset = ExpressionSet(assayData = data.matrix(count_data),phenoData =  new("AnnotatedDataFrame",data = pheno_data,varMetadata = metadata))

#Single Cell data from La Manno et al, PMID: 27716510
#format count and metadata from GSE input
raw_data_Embryo <- read.table("GSE76381_EmbryoMoleculeCounts.cef.txt", sep = "\t")
count_data_Embryo <- raw_data_Embryo[-c(1,3:5),-2]
colnames(count_data_Embryo) <- count_data_Embryo[1,]
rownames(count_data_Embryo) <- count_data_Embryo[,1]
count_data_Embryo <- count_data_Embryo[-1,-1]

metadata_Embryo <- raw_data_Embryo[2:4,-1]
metadata_Embryo <- as.data.frame(t(metadata_Embryo))
colnames(metadata_Embryo) <- metadata_Embryo[1,]
rownames(metadata_Embryo) <- metadata_Embryo[,1]
metadata_Embryo <- metadata_Embryo[-1,]
colnames(metadata_Embryo)[1] <- "Samples_ID"
metadata_Embryo$Cells_timeline <- paste(metadata_Embryo$Cell_type,metadata_Embryo$Timepoint,sep = "_")
metadata_Embryo$Cells_timeline <- gsub("eek_","",metadata_Embryo$Cells_timeline)

##FIGURE 4E

##Timeline Week8
metadata_8w <- dplyr::filter(metadata_Embryo,metadata_Embryo$Timepoint == "week_8")
count_data_Embryo_8w <- count_data_Embryo[,c(colnames(count_data_Embryo) %in% rownames(metadata_8w))]
#Format Sc embryo data
metadata <- data.frame(labelDescription= colnames(metadata_8w), row.names=colnames(metadata_8w))
Sc.embryo.8w.eset = ExpressionSet(assayData = data.matrix(count_data_Embryo_8w),phenoData =  new("AnnotatedDataFrame",data = metadata_8w,varMetadata = metadata))
##Run deconvolution for SN
Est.prop.embryo.8w = music_prop(bulk.eset = BULK.eset, sc.eset = Sc.embryo.8w.eset, clusters = 'Cells_timeline',
                                samples = 'Samples_ID', verbose = F)
cell_prop <- as.data.frame(Est.prop.embryo.8w$Est.prop.weighted)
cell_prop <- cell_prop[c(1,3,5,7,9,11,2,4,6,8,10,12),]
# create heatmap using pheatmap
pheatmap(cell_prop,treeheight_row = 0, treeheight_col = 0, angle_col = "0",
         show_rownames = T, cluster_rows=FALSE)


##FIGURE S3 A

##Timeline Week10
metadata_10w <- dplyr::filter(metadata_Embryo,metadata_Embryo$Timepoint == "week_10")
count_data_Embryo_10w <- count_data_Embryo[,c(colnames(count_data_Embryo) %in% rownames(metadata_10w))]
#Format Sc embryo data
metadata <- data.frame(labelDescription= colnames(metadata_10w), row.names=colnames(metadata_10w))
Sc.embryo.10w.eset = ExpressionSet(assayData = data.matrix(count_data_Embryo_10w),phenoData =  new("AnnotatedDataFrame",data = metadata_10w,varMetadata = metadata))
##Run deconvolution for SN
Est.prop.embryo.10w = music_prop(bulk.eset = BULK.eset, sc.eset = Sc.embryo.10w.eset, clusters = 'Cells_timeline',
                                samples = 'Samples_ID', verbose = F)
cell_prop <- as.data.frame(Est.prop.embryo.10w$Est.prop.weighted)
cell_prop <- cell_prop[c(1,3,5,7,9,11,2,4,6,8,10,12),]
# create heatmap using pheatmap
pheatmap(cell_prop,treeheight_row = 0, treeheight_col = 0, angle_col = "0",
         show_rownames = T, cluster_rows=FALSE)

##FIGURE S3 B

##Timeline Week11
metadata_11w <- dplyr::filter(metadata_Embryo,metadata_Embryo$Timepoint == "week_11")
count_data_Embryo_11w <- count_data_Embryo[,c(colnames(count_data_Embryo) %in% rownames(metadata_11w))]
#Format Sc embryo data
metadata <- data.frame(labelDescription= colnames(metadata_11w), row.names=colnames(metadata_11w))
Sc.embryo.11w.eset = ExpressionSet(assayData = data.matrix(count_data_Embryo_11w),phenoData =  new("AnnotatedDataFrame",data = metadata_11w,varMetadata = metadata))
##Run deconvolution for SN
Est.prop.embryo.11w = music_prop(bulk.eset = BULK.eset, sc.eset = Sc.embryo.11w.eset, clusters = 'Cells_timeline',
                                samples = 'Samples_ID', verbose = F)
cell_prop <- as.data.frame(Est.prop.embryo.11w$Est.prop.weighted)
cell_prop <- cell_prop[c(1,3,5,7,9,11,2,4,6,8,10,12),]
# create heatmap using pheatmap
pheatmap(cell_prop,treeheight_row = 0, treeheight_col = 0, angle_col = "0",
         show_rownames = T, cluster_rows=FALSE)


