library(MuSiC)
library(Biobase)
library(dplyr)
library(Seurat)
library(pheatmap)

######## Deconvolution  of data
load("feature_counts_katja_2022.RData")
count_data <- as.data.frame(fc$counts)
count_data$SYMBOL <- rownames(count_data)

# Convert from gene.symbol to ensembl.gene
library(EnsDb.Hsapiens.v86)
symbol <- rownames(count_data)
ensembl_symbol <- ensembldb::select(EnsDb.Hsapiens.v86, keys= symbol, keytype = "SYMBOL", columns = c("SYMBOL","GENEID"))
count_data2 <- merge(count_data, ensembl_symbol, by="SYMBOL")
rownames(count_data2) <- count_data2$GENEID
count_data2 <- count_data2[,-c(1,14)]
pheno_data <- as.data.frame(readxl::read_xlsx("pheno_matrix.xlsx"))
rownames(pheno_data) <- pheno_data$SampleID

#Format Bulk data
metadata <- data.frame(labelDescription= colnames(pheno_data), row.names=colnames(pheno_data))
BULK.eset = ExpressionSet(assayData = data.matrix(count_data2),phenoData =  new("AnnotatedDataFrame",data = pheno_data,varMetadata = metadata))
# Single cell dataset from Smajic et al
#Input rds
Single_cell_data = readRDS("PD_CO.rds")
#Extract count_matrix
AssayData <- GetAssayData(object = Single_cell_data[["RNA"]], slot = "counts")
AssayData <- as.data.frame(AssayData)
#metadata extract
metadata_Sc <- data.frame(Single_cell_data@meta.data)
ids.names <- unique(metadata_Sc$cell_ontology)
#Merge all neuronals cell types
ids.Neurons <- ids.names[c(2,8,10:12)]
metadata_Sc$cell_ontology[metadata_Sc$cell_ontology %in% ids.Neurons] <- "Neurons"
#Remove endothelial, Pericytes and Microglia from the list
ids.names.to_use <- c("Neurons","OPCs","Astrocytes","Oligodendrocytes","Ependymal")
#Format Reference data
metadata <- data.frame(labelDescription= colnames(metadata_Sc), row.names=colnames(metadata_Sc))
Sc.eset = ExpressionSet(assayData = data.matrix(AssayData),
                        phenoData=new("AnnotatedDataFrame",
                                      data = metadata_Sc,varMetadata = metadata))
##Run deconvolution
Est.prop = music_prop(bulk.eset = BULK.eset, sc.eset = Sc.eset, clusters = 'cell_ontology', select.ct = ids.names.to_use,
                      samples = 'sample', verbose = F)
#Plot heatmap of cell proportion
cell_prop <- as.data.frame(Est.prop$Est.prop.weighted)
cell_prop <- cell_prop[c(1,3,5,7,9,11,2,4,6,8,10,12),]
colnames(cell_prop) <- c("Neur","OPCs","Astro","ODCs","Epend")
pheatmap(cell_prop,treeheight_row = 0, treeheight_col = 0, angle_col = "0",
         show_rownames = T, cluster_rows=FALSE)
