library(MuSiC)
library(Biobase)
library(dplyr)
library(Seurat)
library(pheatmap)

#Input Bulk rna seq
load("feature_counts_katja_2022.RData")
count_data <- as.data.frame(fc$counts)
#prepare meta_data
pheno_data <- as.data.frame(readxl::read_xlsx("pheno_matrix.xlsx"))
rownames(pheno_data) <- pheno_data$SampleID
#Format Bulk data
metadata <- data.frame(labelDescription= colnames(pheno_data), row.names=colnames(pheno_data))
BULK.eset = ExpressionSet(assayData = data.matrix(count_data),phenoData =  new("AnnotatedDataFrame",data = pheno_data,varMetadata = metadata))

# Single cell dataset from Agarwal et al
#Input Cortex rds
Single_cell_data_CTX = readRDS("CT.rds")
Single_cell_data_CTX$seurat_clusters <- Idents(Single_cell_data_CTX)
#Extract count_matrix
AssayData <- GetAssayData(object = Single_cell_data_CTX[["RNA"]], slot = "counts")
#metadata extract
metadata_Sc <- data.frame(Single_cell_data_CTX@meta.data)
metadata_Sc$seurat_clusters <- as.character(metadata_Sc$seurat_clusters)
ids.names <- unique(metadata_Sc$seurat_clusters)
#Merge Neuronal type
metadata_Sc$seurat_clusters[metadata_Sc$seurat_clusters  == "In"] <- "Neurons"
metadata_Sc$seurat_clusters[metadata_Sc$seurat_clusters  == "Ex"] <- "Neurons"
ids.names.to_use <- unique(metadata_Sc$seurat_clusters)
ids.names.to_use <- ids.names.to_use[-2]
#Format Reference data
metadata <- data.frame(labelDescription= colnames(metadata_Sc), row.names=colnames(metadata_Sc))
Sc.eset.CTX = ExpressionSet(assayData = data.matrix(AssayData),
                        phenoData=new("AnnotatedDataFrame",
                                      data = metadata_Sc,varMetadata = metadata))
##Run deconvolution for CT
Est.prop.agrwal.CTX = music_prop(bulk.eset = BULK.eset, sc.eset = Sc.eset.CTX, clusters = 'seurat_clusters', select.ct = ids.names.to_use,
                             samples = 'orig.ident', verbose = F)
cell_prop_CTX <- as.data.frame(Est.prop.agrwal.CTX$Est.prop.weighted)
cell_prop_CTX <- cell_prop_CTX[c(1,3,5,7,9,11,2,4,6,8,10,12),]
colnames(cell_prop_CTX) <- c("Neur","Astro","ODCs","OPCs")

# create heatmap using pheatmap
Music_CTX <- pheatmap(cell_prop_CTX,treeheight_row = 0, treeheight_col = 0, angle_col = "0",
         show_rownames = T, cluster_rows=FALSE)

