##############################################################################################################################
############################################### Gene Ontology Function  ######################################################
###############################################     by Thais Arns       ######################################################
###############################################         07/2021         ######################################################
##############################################################################################################################

gene_set_enrich <- function(gene_symbols,organism,ontology=c("BP", "MF","CC"),qval_thres=0.05,save=TRUE,title=""){
  
  #   gene_symbols : Vector of gene symbols
  #   organism : String with the organism to search
  #   ontology: Vector with the GOterms to check (Default = c("BP"))
  #   qval_thres : qvalue threshold for the significance of the pathway (Default = 0.05)
  #   save : Save plots (Default = TRUE)
  #   title: Title to the saved table and plots
  
  library(biomaRt)
  library(clusterProfiler)
  library(topGO)
  if (tolower(organism) == "human"){
    OrgDb = "org.Hs.eg.db"
    symbols <- gene_symbols
  } else{
    symbols = unlist(lapply(tolower(as.vector(gene_symbols)),simpleCap))
    if(tolower(organism) == "rat"){
      OrgDb = "org.Rn.eg.db"
    } else{
      OrgDb = "org.Mm.eg.db"
    }
  }
  
  library(OrgDb,character.only=TRUE)
  
  eg=bitr(symbols,fromType = "SYMBOL",toType=c("SYMBOL","ENTREZID"),OrgDb=OrgDb)
  head(eg$ENTREZID)
  
  for (ont in ontology){
    ego <- enrichGO(gene          = eg$ENTREZID,
                    OrgDb         = OrgDb,
                    ont           = ont,
                    pAdjustMethod = "BH",
                    pvalueCutoff  = 0.05,
                    qvalueCutoff  = qval_thres,
                    readable = TRUE)
    
    if(save){
      pdf(paste(Sys.Date(),"GO_Dotplot",organism,ont,qval_thres,title,".pdf",sep="_"),height=5,width=10)
      print(dotplot(ego, showCategory=10))
      dev.off()
      pdf(paste(Sys.Date(),"GO_Graph",organism,ont,qval_thres,title,".pdf",sep="_"),height=14,width=18)
      plotGOgraph(ego)
      dev.off()
      
      png(paste(Sys.Date(),"GO_Dotplot",organism,ont,qval_thres,title,".png",sep="_"),height=1500,width=2900, res=300)
      print(dotplot(ego, showCategory=10))
      dev.off()
      
      write.table(ego,file=paste(Sys.Date(),organism,"GO",ont,qval_thres,title,".csv",sep="_"),row.names=FALSE,na="",sep=";")
    }
  }
  
  return(ego)
}

##############################################################################################################################
############################################# Run GO Analysis ################################################################
##############################################################################################################################

library(useful)
library(reshape)

#Read the input gene list
d <- read.table("./DiffExprGenes_pval_0p05_from_MI_0_Ordered_by_FC.csv",header=FALSE,sep=";")

corner(d)
d
class(d)

d <- as.character(d[,1])
d
class(d)

gene_symbols <- d
length(gene_symbols)
corner(gene_symbols)
class(gene_symbols)

#Run Gene Ontology (GO) analysis
a <- gene_set_enrich(gene_symbols,organism="HUMAN",ontology=c("BP","MF","CC"),qval_thres=0.05,save=TRUE,title="")
