##############################################################################################################################
####################################################### Day 0 ################################################################
##############################################################################################################################

#Common GO Terms

#setwd("SET PATH TO DATA LOCATION")

library(useful)
library(reshape)
library(tidyverse)
library(scico)
library(ggplot2)

data <- read.csv("grepped_Susan_0_BP_common.csv", sep =";", header = TRUE, stringsAsFactors = FALSE)
corner(data)

tmp <- sapply(strsplit(data$GeneRatio, split = "/"), function(x) as.numeric(x[1]) / as.numeric(x[2]))
cols <- c("Generatio")
nC <- length(cols)
ind <- seq(from=1, by=nC, length=nrow(data))
for(i in 1:nC) {
  data[, cols[i]] <- tmp[ind + i - 1]
}

head(data)

#Order data
full_table <- data[order(data$p.adjust), c("ID", "Description", "GeneRatio", "BgRatio", "pvalue", "p.adjust", "qvalue", "geneID", "Count", "Generatio")]
head(full_table)

#Save full_table
write.csv2(full_table, "grepped_Susan_0_BP_common_full_table.csv")

#Print the top 10 GOs

yy <- full_table[1:10,]
yy

yy <- ggplot(yy,aes(x = Generatio, y = Description)) +
  geom_point(aes(size = Count, color = p.adjust )) +
  theme_bw(base_size =14) +
  scale_colour_gradient(limits=c(0, 0.05), low="blue", high="red") +
  ylab(NULL) +
  xlab("Gene Ratio")

#Save plot as PDF
pdf("grepped_Susan_0_BP_common_plot_10.pdf", width=9, height=4)
yy
dev.off()

#save plot as PNG
png("grepped_Susan_0_BP_common_plot_10.png", width=2700, height=1100, res=300)
yy
dev.off()
