# First analysis of Mitras data 0813
# Alexander Skupin, 2013-09-067
# Last change: 2013-09-15

#setwd('/Volumes/Macintosh HD 2/projects/science_projects/single_cell_ana_mitra/biotrove_data/followup_analysis')
library('infotheo')
library('vioplot')
library('caroline')# for other violineplots
library('gplots')

library(gplots)
library(vioplot)
library(corrgram)
library(lawstat)
library(car)
library(Hmisc)
library('made4')

library(longitudinal)
library(rgl)
library(scatterplot3d)
library(mclust)
library(cluster)

library(psych)

############FOR GENEORDER !!! noseallSC2 <- seallSC[,c(18,9,12,15,2,8,17,7,16,13,4,1,10,11,14,6,3,5,19)]


source('heatmap.3.R')
# read raw data

genam <- c("sfpi1","Hba-a1","Egr2","ckit","TBP","CD11b","Runx1","Scl","EpoR","CEBPa","Gfi1","Eklf","cMyb","cJun","Fog1","Gata2","Fli1","Gata1","Gapdh")

cna <- c("number","chip","sca1_state","population",genam)

tircs <-read.csv('chip_IRCs_sorted.csv',header=T) # ircs loading
ircs  <- tircs[c(1,2,57:75)] # only medians
colnames(ircs) <- c("chip","state",genam)


temld0<-read.csv('eml_d0.csv',header=T)# controle
emld0 <-temld0[c(1:150),c(1:4,59:77)]
colnames(emld0)<-cna

teryd1<-read.csv('ery_d1.csv',header=T)
eryd1 <-teryd1[,c(1:4,59:77)]
colnames(eryd1)<-cna

teryd3<-read.csv('ery_d3.csv',header=T)
eryd3 <-teryd3[,c(1:4,59:77)]
colnames(eryd3)<-cna

teryd6<-read.csv('ery_d6.csv',header=T)
eryd6 <-teryd6[,c(1:4,59:77)]
colnames(eryd6)<-cna

tmyld1<-read.csv('myl_d1.csv',header=T)
myld1 <-tmyld1[,c(1:4,59:77)]
colnames(myld1)<-cna

tmyld3<-read.csv('myl_d3.csv',header=T)
myld3 <-tmyld3[c(1:200),c(1:4,59:77)]
colnames(myld3)<-cna

tmyld6<-read.csv('myl_d6.csv',header=T)
myld6 <-tmyld6[,c(1:4,59:77)]
colnames(myld6)<-cna

tcomd1<-read.csv('com_d1.csv',header=T)
comd1 <-tcomd1[,c(1:4,59:77)]
colnames(comd1)<-cna

tcomd3<-read.csv('com_d3.csv',header=T)
comd3 <-tcomd3[,c(1:4,59:77)]
colnames(comd3)<-cna

tcomd6<-read.csv('com_d6.csv',header=T)
comd6 <-tcomd6[,c(1:4,59:77)]
colnames(comd6)<-cna


# copy with NA for correlation analysis
allSCCt<- rbind(emld0,eryd1,eryd3,eryd6,myld1,myld3,myld6,comd1,comd3,comd6)

allcellcorct<- cor(t(allSCCt[,c(5:23)]),use="complete.obs")

#for common maximum temppool
#tempool<-rbind(mal,mbe,mga,md0)
#totmax<- ceiling(max(tempool))

#TO COMPARE CELL CORRELATION WITH NA TO NOISE
coemld0 <- emld0	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(emld0)[1])){
		if (is.na(emld0[j,i])){
			coemld0[j,i] <- max(emld0[,c(5:23)][!is.na(emld0[,c(5:23)])])+runif(1,0.,.1)*max(emld0[,c(5:23)][!is.na(emld0[,c(5:23)])])
#print("dola")
			ni<-ni+1
		}
	}
}
print(ni)

coeryd1 <- eryd1
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(eryd1)[1])){
		if (is.na(eryd1[j,i])){
			coeryd1[j,i] <- max(eryd1[,c(5:23)][!is.na(eryd1[,c(5:23)])])+runif(1,0.,.1)*max(eryd1[,c(5:23)][!is.na(eryd1[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

coeryd3 <- eryd3	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(eryd3)[1])){
		if (is.na(eryd3[j,i])){
			coeryd3[j,i] <- max(eryd3[,c(5:23)][!is.na(eryd3[,c(5:23)])])+runif(1,0.,.1)*max(eryd3[,c(5:23)][!is.na(eryd3[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

coeryd6 <- eryd6	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(eryd6)[1])){
		if (is.na(eryd6[j,i])){
			coeryd6[j,i] <- max(eryd6[,c(5:23)][!is.na(eryd6[,c(5:23)])])+runif(1,0.,.1)*max(eryd6[,c(5:23)][!is.na(eryd6[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

##myl
comyld1 <- myld1
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(myld1)[1])){
		if (is.na(myld1[j,i])){
			comyld1[j,i] <- max(myld1[,c(5:23)][!is.na(myld1[,c(5:23)])])+runif(1,0.,.1)*max(myld1[,c(5:23)][!is.na(myld1[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

comyld3 <- myld3	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(myld3)[1])){
		if (is.na(myld3[j,i])){
			comyld3[j,i] <- max(myld3[,c(5:23)][!is.na(myld3[,c(5:23)])])+runif(1,0.,.1)*max(myld3[,c(5:23)][!is.na(myld3[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

comyld6 <- myld6	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(myld6)[1])){
		if (is.na(myld6[j,i])){
			comyld6[j,i] <- max(myld6[,c(5:23)][!is.na(myld6[,c(5:23)])])+runif(1,0.,.1)*max(myld6[,c(5:23)][!is.na(myld6[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)
##com
cocomd1 <- comd1
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(myld1)[1])){
		if (is.na(comd1[j,i])){
			cocomd1[j,i] <- max(comd1[,c(5:23)][!is.na(comd1[,c(5:23)])])+runif(1,0.,.1)*max(comd1[,c(5:23)][!is.na(comd1[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

cocomd6 <- comd6	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(comd6)[1])){
		if (is.na(comd6[j,i])){
			cocomd6[j,i] <- max(comd6[,c(5:23)][!is.na(comd6[,c(5:23)])])+runif(1,0.,.1)*max(comd6[,c(5:23)][!is.na(comd6[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

cocomd3 <- comd3	
ni<-0
for (i in c(5:23)){
	for (j in c(1:dim(comd3)[1])){
		if (is.na(comd3[j,i])){
			cocomd3[j,i] <- max(comd3[,c(5:23)][!is.na(comd3[,c(5:23)])])+runif(1,0.,.1)*max(comd3[,c(5:23)][!is.na(comd3[,c(5:23)])])
			ni<-ni+1
		}
	}
}
print(ni)

# set all NA Ct values to  maximum of subpopulation
emld0[,c(5:23)][is.na(emld0[,c(5:23)])] <- max(emld0[,c(5:23)][!is.na(emld0[,c(5:23)])])#+runif(1,0.,.1)*max(emld0[,c(5:23)][!is.na(emld0[,c(5:23)])])
eryd1[,c(5:23)][is.na(eryd1[,c(5:23)])] <- max(eryd1[,c(5:23)][!is.na(eryd1[,c(5:23)])])
eryd3[,c(5:23)][is.na(eryd3[,c(5:23)])] <- max(eryd3[,c(5:23)][!is.na(eryd3[,c(5:23)])])
eryd6[,c(5:23)][is.na(eryd6[,c(5:23)])] <- max(eryd6[,c(5:23)][!is.na(eryd6[,c(5:23)])])
myld1[,c(5:23)][is.na(myld1[,c(5:23)])] <- max(myld1[,c(5:23)][!is.na(myld1[,c(5:23)])])
myld3[,c(5:23)][is.na(myld3[,c(5:23)])] <- max(myld3[,c(5:23)][!is.na(myld3[,c(5:23)])])
myld6[,c(5:23)][is.na(myld6[,c(5:23)])] <- max(myld6[,c(5:23)][!is.na(myld6[,c(5:23)])])
comd1[,c(5:23)][is.na(comd1[,c(5:23)])] <- max(comd1[,c(5:23)][!is.na(comd1[,c(5:23)])])
comd3[,c(5:23)][is.na(comd3[,c(5:23)])] <- max(comd3[,c(5:23)][!is.na(comd3[,c(5:23)])])
comd6[,c(5:23)][is.na(comd6[,c(5:23)])] <- max(comd6[,c(5:23)][!is.na(comd6[,c(5:23)])])


# set all NA Ct values to global maximum of all subpopulations
#mal[,][is.na(mal[,])] <- totmax
#mbe[,][is.na(mbe[,])] <- totmax
#mga[,][is.na(mga[,])] <- totmax
#md0[,][is.na(md0[,])] <- totmax

rownames(emld0)<-paste(emld0[,4],emld0[,3],emld0[,2],emld0[,1])
rownames(eryd1)<-paste(eryd1[,4],eryd1[,3],eryd1[,2],eryd1[,1])
rownames(eryd3)<-paste(eryd3[,4],eryd3[,3],eryd3[,2],eryd3[,1])
rownames(eryd6)<-paste(eryd6[,4],eryd6[,3],eryd6[,2],eryd6[,1])
rownames(myld1)<-paste(myld1[,4],myld1[,3],myld1[,2],myld1[,1])
rownames(myld3)<-paste(myld3[,4],myld3[,3],myld3[,2],myld3[,1])
rownames(myld6)<-paste(myld6[,4],myld6[,3],myld6[,2],myld6[,1])
rownames(comd1)<-paste(comd1[,4],comd1[,3],comd1[,2],comd1[,1])
rownames(comd3)<-paste(comd3[,4],comd3[,3],comd3[,2],comd3[,1])
rownames(comd6)<-paste(comd6[,4],comd6[,3],comd6[,2],comd6[,1])


#pool all single cells together 
allSC<- rbind(emld0,eryd1,eryd3,eryd6,myld1,myld3,myld6,comd1,comd3,comd6)
gasa<-as.matrix(allSC[,c(5:23)]) 

#CT values with random NA replacement
coallSC<- rbind(coemld0,coeryd1,coeryd3,coeryd6,comyld1,comyld3,comyld6,cocomd1,cocomd3,cocomd6)
cogasa<-as.matrix(coallSC[,c(5:23)]) 

#pdf('ct_singlecells_clustering.pdf',width=8,height=96)
#  heatmap.2((gasa),trace="none")
# dev.off()



#do expression single cells
set<-max(allSC) # set preamplification cycle
# MAX LEVELS
seted0<-max(emld0[,c(5:23)]) # set preamplification cycle
seted1<-max(eryd1[,c(5:23)]) # set preamplification cycle
seted3<-max(eryd3[,c(5:23)]) # set preamplification cycle
seted6<-max(eryd6[,c(5:23)]) # set preamplification cycle
setmd1<-max(myld1[,c(5:23)]) # set preamplification cycle
setmd3<-max(myld3[,c(5:23)]) # set preamplification cycle
setmd6<-max(myld6[,c(5:23)]) # set preamplification cycle
setcd1<-max(comd1[,c(5:23)]) # set preamplification cycle
setcd3<-max(comd3[,c(5:23)]) # set preamplification cycle
setcd6<-max(comd6[,c(5:23)]) # set preamplification cycle

#trransform to log2 expression
eemld0 <- log2(2^(seted0-as.matrix(emld0[,c(5:23)])))

eeryd1 <- log2(2^(seted1-as.matrix(eryd1[,c(5:23)])))
eeryd3 <- log2(2^(seted3-as.matrix(eryd3[,c(5:23)])))
eeryd6 <- log2(2^(seted6-as.matrix(eryd6[,c(5:23)])))

emyld1 <- log2(2^(setmd1-as.matrix(myld1[,c(5:23)])))
emyld3 <- log2(2^(setmd3-as.matrix(myld3[,c(5:23)])))
emyld6 <- log2(2^(setmd6-as.matrix(myld6[,c(5:23)])))

ecomd1 <- log2(2^(setcd1-as.matrix(comd1[,c(5:23)])))
ecomd3 <- log2(2^(setcd3-as.matrix(comd3[,c(5:23)])))
ecomd6 <- log2(2^(setcd6-as.matrix(comd6[,c(5:23)])))


######## sorting wrt sca1 level
#sort vectors
soed0<-sort.list(emld0[,3])

soed1<-sort.list(eryd1[,3])
soed3<-sort.list(eryd3[,3])
soed6<-sort.list(eryd6[,3])

somd1<-sort.list(myld1[,3])
somd3<-sort.list(myld3[,3])
somd6<-sort.list(myld6[,3])

somc1<-sort.list(comd1[,3])
somc3<-sort.list(comd1[,3])
somc6<-sort.list(comd1[,3])

# putting them into the right order to obtain expression in right order
semld0 <- eemld0[soed0,]

seryd1 <- eeryd1[soed1,]
seryd3 <- eeryd3[soed3,]
seryd6 <- eeryd6[soed6,]

smyld1 <- emyld1[somd1,]
smyld3 <- emyld3[somd3,]
smyld6 <- emyld6[somd6,]

scomd1 <- ecomd1[somc1,]
scomd3 <- ecomd3[somc3,]
scomd6 <- ecomd6[somc6,]

com <- colorRampPalette(c("royalblue1","blue","darkblue"))(3) #"royalblue1"
coe <- colorRampPalette(c("salmon","red","darkred"))(3)  #"lightcyan2"
coc <- colorRampPalette(c("darkmagenta","magenta","purple"))(3)  #"magenta"
co0 <- "black"


colar<-c(rep(c(co0), dim(semld0)[1]),rep(c(coe[1]), dim(eeryd1)[1]),rep(c(coe[2]), dim(eeryd3)[1])
,rep(c(coe[3]), dim(eeryd6)[1]),rep(c(com[1]), dim(emyld1)[1]),rep(c(com[2]), dim(emyld3)[1])
,rep(c(com[3]), dim(emyld6)[1]),rep(c(coc[1]), dim(ecomd1)[1]),rep(c(coc[2]), dim(ecomd3)[1])
,rep(c(coc[3]), dim(ecomd6)[1]))

colar2<-c(rep(c(co0), dim(semld0)[1]),rep(c(coe[1]), dim(eeryd1)[1]),rep(c(coe[2]), dim(eeryd3)[1])
,rep(c(coe[3]), dim(eeryd6)[1]),rep(c(com[1]), dim(emyld1)[1]),rep(c(com[2]), dim(emyld3)[1])
,rep(c(com[3]), dim(emyld6)[1]),rep(c(coc[1]), dim(ecomd1)[1]),rep(c(coc[2]), dim(ecomd3)[1]-1)
,rep(c(coc[3]), dim(ecomd6)[1]))

sallSC<- rbind(semld0,seryd1,seryd3,seryd6,smyld1,smyld3,smyld6,scomd1,scomd3,scomd6)

column_annotation <- colar
column_annotation <- as.matrix(column_annotation)
colnames(column_annotation) <- c("Subpopulation")

column_annotation2 <- colar2
column_annotation2 <- as.matrix(column_annotation2)
colnames(column_annotation2) <- c("Subpopulation")

hmcols<-colorRampPalette(c("grey","orange","red"))(256)

######## for sca1 state population
#emldo population
ed0_sub_low<-eemld0[emld0$sca1_state=="LOW-SCA1",]
ed0_sub_mid<-eemld0[emld0$sca1_state=="MID-SCA1",]
ed0_sub_high<-eemld0[emld0$sca1_state=="HIGH-SCA1",]

#eryd1 population
eryd1_sub_low  <-eeryd1[eryd1$sca1_state=="LOW-SCA1",]
eryd1_sub_mid  <-eeryd1[eryd1$sca1_state=="MID-SCA1",]
eryd1_sub_high <-eeryd1[eryd1$sca1_state=="HIGH-SCA1",]

#eryd3 population
eryd3_sub_low  <-eeryd3[eryd3$sca1_state=="LOW-SCA1",]
eryd3_sub_mid1 <-eeryd3[eryd3$sca1_state=="MID1-SCA1",]
eryd3_sub_mid2 <-eeryd3[eryd3$sca1_state=="MID2-SCA1",]
eryd3_sub_high <-eeryd3[eryd3$sca1_state=="HIGH-SCA1",]

#eryd6 population
eryd6_sub_low  <-eeryd6[eryd6$sca1_state=="LOW-SCA1",]
eryd6_sub_mid  <-eeryd6[eryd6$sca1_state=="MID-SCA1",]
eryd6_sub_high <-eeryd6[eryd6$sca1_state=="HIGH-SCA1",]

#myld1 population
myld1_sub_low  <-emyld1[myld1$sca1_state=="LOW-SCA1",]
myld1_sub_mid  <-emyld1[myld1$sca1_state=="MID-SCA1",]
myld1_sub_high <-emyld1[myld1$sca1_state=="HIGH-SCA1",]

#myld3 population
myld3_sub_low  <-emyld3[myld3$sca1_state=="LOW-SCA1",]
myld3_sub_mid1 <-emyld3[myld3$sca1_state=="MID1-SCA1",]
myld3_sub_mid2 <-emyld3[myld3$sca1_state=="MID2-SCA1",]
myld3_sub_high <-emyld3[myld3$sca1_state=="HIGH-SCA1",]

#myld6 population
myld6_sub_low  <-emyld6[myld6$sca1_state=="LOW-SCA1",]
myld6_sub_mid  <-emyld6[myld6$sca1_state=="MID-SCA1",]
myld6_sub_high <-emyld6[myld6$sca1_state=="HIGH-SCA1",]

#comd1 population
comd1_sub_low  <-ecomd1[comd1$sca1_state=="LOW-SCA1",]
comd1_sub_mid  <-ecomd1[comd1$sca1_state=="MID-SCA1",]
comd1_sub_high <-ecomd1[comd1$sca1_state=="HIGH-SCA1",]

#comd3 population
comd3_sub_low  <-ecomd3[comd3$sca1_state=="LOW-SCA1",] #FIXME: WHERE IS IT?
comd3_sub_mid1 <-ecomd3[comd3$sca1_state=="MID1-SCA1",]
comd3_sub_mid2 <-ecomd3[comd3$sca1_state=="MID2-SCA1",]
comd3_sub_high <-ecomd3[comd3$sca1_state=="HIGH-SCA1",]

#comd6 population
comd6_sub_low  <-ecomd6[comd6$sca1_state=="LOW-SCA1",]
comd6_sub_mid  <-ecomd6[comd6$sca1_state=="MID-SCA1",]
comd6_sub_high <-ecomd6[comd6$sca1_state=="HIGH-SCA1",]


coe2 <- colorRampPalette(c("salmon","darkred"))(10) #"royalblue1"
com2 <- colorRampPalette(c("royalblue1","blue","darkblue"))(10)#c("lightcyan","cyan","darkcyan"))(10)  #"lightcyan2"
coc2 <- colorRampPalette(c("magenta","purple","darkmagenta"))(10)  #"magenta"
co02 <- colorRampPalette(c("grey","darkgrey","black"))(3)  #"magenta"

coe2 <- colorRampPalette(c("red","red","red"))(10) #"royalblue1"
com2 <- colorRampPalette(c("blue","blue","blue"))(10)#c("lightcyan","cyan","darkcyan"))(10)  #"lightcyan2"
coc2 <- colorRampPalette(c("purple","purple","purple"))(10)  #"magenta"
co02 <- colorRampPalette(c("black","black","black"))(3)  #"magenta"

coe2 <- colorRampPalette(c("salmon","darkred"))(4) #"royalblue1"
com2 <- colorRampPalette(c("royalblue1","blue","darkblue"))(4)#c("lightcyan","cyan","darkcyan"))(10)  #"lightcyan2"
coc2 <- colorRampPalette(c("magenta","purple","darkmagenta"))(4)  #"magenta"
co02 <- colorRampPalette(c("grey","darkgrey","black"))(3)  #"magenta"

colarsub<-c(rep(c(co02[1]), dim(ed0_sub_low)[1]),
rep(c(co02[2]), dim(ed0_sub_mid)[1]),
rep(c(co02[3]), dim(ed0_sub_high)[1]),
rep(c(coe2[1]), dim(eryd1_sub_low)[1]),
rep(c(coe2[2]), dim(eryd1_sub_mid)[1]),
rep(c(coe2[3]), dim(eryd1_sub_high)[1]),
rep(c(coe2[4]), dim(eryd3_sub_low)[1]),
rep(c(coe2[5]), dim(eryd3_sub_mid1)[1]),
rep(c(coe2[6]), dim(eryd3_sub_mid2)[1]),
rep(c(coe2[7]), dim(eryd3_sub_high)[1]),
rep(c(coe2[8]), dim(eryd6_sub_low)[1]),
rep(c(coe2[9]), dim(eryd6_sub_mid)[1]),
rep(c(coe2[10]), dim(eryd6_sub_high)[1]),
rep(c(com2[1]), dim(myld1_sub_low)[1]),
rep(c(com2[2]), dim(myld1_sub_mid)[1]),
rep(c(com2[3]), dim(myld1_sub_high)[1]),
rep(c(com2[4]), dim(myld3_sub_low)[1]),
rep(c(com2[5]), dim(myld3_sub_mid1)[1]),
rep(c(com2[6]), dim(myld3_sub_mid2)[1]),
rep(c(com2[7]), dim(myld3_sub_high)[1]),
rep(c(com2[8]), dim(myld6_sub_low)[1]),
rep(c(com2[9]), dim(myld6_sub_mid)[1]),
rep(c(com2[10]), dim(myld6_sub_high)[1]),
rep(c(coc2[1]), dim(comd1_sub_low)[1]),
rep(c(coc2[2]), dim(comd1_sub_mid)[1]),
rep(c(coc2[3]), dim(comd1_sub_high)[1]),
rep(c(coc2[4]), dim(comd3_sub_low)[1]),
rep(c(coc2[5]), dim(comd3_sub_mid1)[1]),
rep(c(coc2[6]), dim(comd3_sub_mid2)[1]),
rep(c(coc2[7]), dim(comd3_sub_high)[1]),
rep(c(coc2[8]), dim(comd6_sub_low)[1]),
rep(c(coc2[9]), dim(comd6_sub_mid)[1]),
rep(c(coc2[10]), dim(comd6_sub_high)[1]))

colarsub2<-c(rep(c(co02[1]), dim(ed0_sub_low)[1]),rep(c(co02[2]), dim(ed0_sub_mid)[1]),
rep(c(co02[3]), dim(ed0_sub_high)[1]),
rep(c(coe2[1]), dim(eryd1_sub_low)[1]),
rep(c(coe2[2]), dim(eryd1_sub_mid)[1]),
rep(c(coe2[3]), dim(eryd1_sub_high)[1]),
rep(c(coe2[4]), dim(eryd3_sub_low)[1]),
rep(c(coe2[5]), dim(eryd3_sub_mid1)[1]),
rep(c(coe2[6]), dim(eryd3_sub_mid2)[1]),
rep(c(coe2[7]), dim(eryd3_sub_high)[1]),
rep(c(coe2[8]), dim(eryd6_sub_low)[1]),
rep(c(coe2[9]), dim(eryd6_sub_mid)[1]),
rep(c(coe2[10]), dim(eryd6_sub_high)[1]),
rep(c(com2[1]), dim(myld1_sub_low)[1]),
rep(c(com2[2]), dim(myld1_sub_mid)[1]),
rep(c(com2[3]), dim(myld1_sub_high)[1]),
rep(c(com2[4]), dim(myld3_sub_low)[1]),
rep(c(com2[5]), dim(myld3_sub_mid1)[1]),
rep(c(com2[6]), dim(myld3_sub_mid2)[1]),
rep(c(com2[7]), dim(myld3_sub_high)[1]),
rep(c(com2[8]), dim(myld6_sub_low)[1]),
rep(c(com2[9]), dim(myld6_sub_mid)[1]),
rep(c(com2[10]), dim(myld6_sub_high)[1]),
rep(c(coc2[1]), dim(comd1_sub_low)[1]),
rep(c(coc2[2]), dim(comd1_sub_mid)[1]),
rep(c(coc2[3]), dim(comd1_sub_high)[1]),
rep(c(coc2[4]), dim(comd3_sub_low)[1]),
rep(c(coc2[5]), dim(comd3_sub_mid1)[1]-1),
rep(c(coc2[6]), dim(comd3_sub_mid2)[1]),
rep(c(coc2[7]), dim(comd3_sub_high)[1]),
rep(c(coc2[8]), dim(comd6_sub_low)[1]),
rep(c(coc2[9]), dim(comd6_sub_mid)[1]),
rep(c(coc2[10]), dim(comd6_sub_high)[1]))


sallSCsub <- rbind(ed0_sub_low,ed0_sub_mid,ed0_sub_high,
eryd1_sub_low,eryd1_sub_mid,eryd1_sub_high,
eryd3_sub_low,eryd3_sub_mid1,eryd3_sub_mid2,eryd3_sub_high,
eryd6_sub_low,eryd6_sub_mid,eryd6_sub_high,
myld1_sub_low,myld1_sub_mid,myld1_sub_high,
myld3_sub_low,myld3_sub_mid1,myld3_sub_mid2,myld3_sub_high,
myld6_sub_low,myld6_sub_mid,myld6_sub_high,
comd1_sub_low,comd1_sub_mid,comd1_sub_high,
comd3_sub_low,comd3_sub_mid1,comd3_sub_mid2,comd3_sub_high,
comd6_sub_low,comd6_sub_mid,comd6_sub_high)

column_annotationsub <- colarsub
column_annotationsub <- as.matrix(column_annotationsub)
colnames(column_annotationsub) <- c("Subpopulation")

column_annotationsub2 <- colarsub2
column_annotationsub2 <- as.matrix(column_annotationsub2)
colnames(column_annotationsub2) <- c("Subpopulation")

########for order according to days
colarsubdayorder <-c(rep(c(co02[1]), dim(ed0_sub_low)[1]),
rep(c(co02[2]), dim(ed0_sub_mid)[1]),
rep(c(co02[3]), dim(ed0_sub_high)[1]),
rep(c(coe2[1]), dim(eryd1_sub_low)[1]),
rep(c(coe2[2]), dim(eryd1_sub_mid)[1]),
rep(c(coe2[3]), dim(eryd1_sub_high)[1]),
rep(c(com2[1]), dim(myld1_sub_low)[1]),
rep(c(com2[2]), dim(myld1_sub_mid)[1]),
rep(c(com2[3]), dim(myld1_sub_high)[1]),
rep(c(coc2[1]), dim(comd1_sub_low)[1]),
rep(c(coc2[2]), dim(comd1_sub_mid)[1]),
rep(c(coc2[3]), dim(comd1_sub_high)[1]),
rep(c(coe2[4]), dim(eryd3_sub_low)[1]),
rep(c(coe2[5]), dim(eryd3_sub_mid1)[1]),
rep(c(coe2[6]), dim(eryd3_sub_mid2)[1]),
rep(c(coe2[7]), dim(eryd3_sub_high)[1]),
rep(c(com2[4]), dim(myld3_sub_low)[1]),
rep(c(com2[5]), dim(myld3_sub_mid1)[1]),
rep(c(com2[6]), dim(myld3_sub_mid2)[1]),
rep(c(com2[7]), dim(myld3_sub_high)[1]),
rep(c(coc2[4]), dim(comd3_sub_low)[1]),
rep(c(coc2[5]), dim(comd3_sub_mid1)[1]),
rep(c(coc2[6]), dim(comd3_sub_mid2)[1]),
rep(c(coc2[7]), dim(comd3_sub_high)[1]),
rep(c(coe2[8]), dim(eryd6_sub_low)[1]),
rep(c(coe2[9]), dim(eryd6_sub_mid)[1]),
rep(c(coe2[10]), dim(eryd6_sub_high)[1]),
rep(c(com2[8]), dim(myld6_sub_low)[1]),
rep(c(com2[9]), dim(myld6_sub_mid)[1]),
rep(c(com2[10]), dim(myld6_sub_high)[1]),
rep(c(coc2[8]), dim(comd6_sub_low)[1]),
rep(c(coc2[9]), dim(comd6_sub_mid)[1]),
rep(c(coc2[10]), dim(comd6_sub_high)[1]))

sallSCsubdayorder <- rbind(ed0_sub_low,ed0_sub_mid,ed0_sub_high,
eryd1_sub_low,eryd1_sub_mid,eryd1_sub_high,
myld1_sub_low,myld1_sub_mid,myld1_sub_high,
comd1_sub_low,comd1_sub_mid,comd1_sub_high,
eryd3_sub_low,eryd3_sub_mid1,eryd3_sub_mid2,eryd3_sub_high,
myld3_sub_low,myld3_sub_mid1,myld3_sub_mid2,myld3_sub_high,
comd3_sub_low,comd3_sub_mid1,comd3_sub_mid2,comd3_sub_high,
eryd6_sub_low,eryd6_sub_mid,eryd6_sub_high,
myld6_sub_low,myld6_sub_mid,myld6_sub_high,
comd6_sub_low,comd6_sub_mid,comd6_sub_high)

column_annotationsubdo <- colarsubdayorder
column_annotationsubdo <- as.matrix(column_annotationsubdo)
colnames(column_annotationsubdo) <- c("Subpopulation")

corcol<-colorRampPalette(c("navy","cyan","white","grey","red"))(256)
corcol<-colorRampPalette(c("navy","cyan","white","grey","red"))(256)

colarsub_ed0<-c(rep(c(co02[1]), dim(ed0_sub_low)[1]),rep(c(co02[2]), dim(ed0_sub_mid)[1]),
rep(c(co02[3]), dim(ed0_sub_high)[1]))

colarsub_ery <- c(rep(c(coe2[1]), dim(eryd1_sub_low)[1]),
rep(c(coe2[2]), dim(eryd1_sub_mid)[1]),
rep(c(coe2[3]), dim(eryd1_sub_high)[1]),
rep(c(coe2[4]), dim(eryd3_sub_low)[1]),
rep(c(coe2[5]), dim(eryd3_sub_mid1)[1]),
rep(c(coe2[6]), dim(eryd3_sub_mid2)[1]),
rep(c(coe2[7]), dim(eryd3_sub_high)[1]),
rep(c(coe2[8]), dim(eryd6_sub_low)[1]),
rep(c(coe2[9]), dim(eryd6_sub_mid)[1]),
rep(c(coe2[10]), dim(eryd6_sub_high)[1]))

colarsub_myl<- c(rep(c(com2[1]), dim(myld1_sub_low)[1]),
rep(c(com2[2]), dim(myld1_sub_mid)[1]),
rep(c(com2[3]), dim(myld1_sub_high)[1]),
rep(c(com2[4]), dim(myld3_sub_low)[1]),
rep(c(com2[5]), dim(myld3_sub_mid1)[1]),
rep(c(com2[6]), dim(myld3_sub_mid2)[1]),
rep(c(com2[7]), dim(myld3_sub_high)[1]),
rep(c(com2[8]), dim(myld6_sub_low)[1]),
rep(c(com2[9]), dim(myld6_sub_mid)[1]),
rep(c(com2[10]), dim(myld6_sub_high)[1]))

#in d3 com mid 1 is outlier
colarsub_com<- c(rep(c(coc2[1]), dim(comd1_sub_low)[1]),
rep(c(coc2[2]), dim(comd1_sub_mid)[1]),
rep(c(coc2[3]), dim(comd1_sub_high)[1]),
rep(c(coc2[4]), dim(comd3_sub_low)[1]),
rep(c(coc2[5]), dim(comd3_sub_mid1)[1]-1),
rep(c(coc2[6]), dim(comd3_sub_mid2)[1]),
rep(c(coc2[7]), dim(comd3_sub_high)[1]),
rep(c(coc2[8]), dim(comd6_sub_low)[1]),
rep(c(coc2[9]), dim(comd6_sub_mid)[1]),
rep(c(coc2[10]), dim(comd6_sub_high)[1]))


sallSCsub_ed0 <- rbind(ed0_sub_low,ed0_sub_mid,ed0_sub_high)

sallSCsub_ery <- rbind(eryd1_sub_low,eryd1_sub_mid,eryd1_sub_high,
eryd3_sub_low,eryd3_sub_mid1,eryd3_sub_mid2,eryd3_sub_high,
eryd6_sub_low,eryd6_sub_mid,eryd6_sub_high)

sallSCsub_myl <- rbind(myld1_sub_low,myld1_sub_mid,myld1_sub_high,
myld3_sub_low,myld3_sub_mid1,myld3_sub_mid2,myld3_sub_high,
myld6_sub_low,myld6_sub_mid,myld6_sub_high)

sallSCsub_com <- rbind(comd1_sub_low,comd1_sub_mid,comd1_sub_high,
comd3_sub_low,comd3_sub_mid1[-8,],comd3_sub_mid2,comd3_sub_high,
comd6_sub_low,comd6_sub_mid,comd6_sub_high)

colarsub_d0<-c(rep(c(co02[1]), dim(ed0_sub_low)[1]),
rep(c(co02[2]), dim(ed0_sub_mid)[1]),
rep(c(co02[3]), dim(ed0_sub_high)[1]))


colarsub_d1<-c(rep(c(coe2[1]), dim(eryd1_sub_low)[1]),
rep(c(coe2[2]), dim(eryd1_sub_mid)[1]),
rep(c(coe2[3]), dim(eryd1_sub_high)[1]),
rep(c(com2[1]), dim(myld1_sub_low)[1]),
rep(c(com2[2]), dim(myld1_sub_mid)[1]),
rep(c(com2[3]), dim(myld1_sub_high)[1]),
rep(c(coc2[1]), dim(comd1_sub_low)[1]),
rep(c(coc2[2]), dim(comd1_sub_mid)[1]),
rep(c(coc2[3]), dim(comd1_sub_high)[1]))

colarsub_d3<-c(rep(c(coe2[4]), dim(eryd3_sub_low)[1]),
rep(c(coe2[5]), dim(eryd3_sub_mid1)[1]),
rep(c(coe2[6]), dim(eryd3_sub_mid2)[1]),
rep(c(coe2[7]), dim(eryd3_sub_high)[1]),
rep(c(com2[4]), dim(myld3_sub_low)[1]),
rep(c(com2[5]), dim(myld3_sub_mid1)[1]),
rep(c(com2[6]), dim(myld3_sub_mid2)[1]),
rep(c(com2[7]), dim(myld3_sub_high)[1]),
rep(c(coc2[4]), dim(comd3_sub_low)[1]),
rep(c(coc2[5]), dim(comd3_sub_mid1)[1]),
rep(c(coc2[6]), dim(comd3_sub_mid2)[1]),
rep(c(coc2[7]), dim(comd3_sub_high)[1]))

colarsub_d6<-c(rep(c(coe2[8]), dim(eryd6_sub_low)[1]),
rep(c(coe2[9]), dim(eryd6_sub_mid)[1]),
rep(c(coe2[10]), dim(eryd6_sub_high)[1]),
rep(c(com2[8]), dim(myld6_sub_low)[1]),
rep(c(com2[9]), dim(myld6_sub_mid)[1]),
rep(c(com2[10]), dim(myld6_sub_high)[1]),
rep(c(coc2[8]), dim(comd6_sub_low)[1]),
rep(c(coc2[9]), dim(comd6_sub_mid)[1]),
rep(c(coc2[10]), dim(comd6_sub_high)[1]))


