
#############################################################################
# PACKAGES

library(tidyverse)
library(plyr)
library(ggplot2)
library(forcats)
library(hrbrthemes)
library(viridis)
library(scales)
library(ggpubr)
library(rstatix)
library(ggsignif)
library(readxl)

setwd('D:/old_win-macbook/R/R/micmac')

##############################################################################
# FUNCTIONS

blue_theme <- function() {
  theme(
    
    # modify text, axis and colour 4) and 5)
    axis.text = element_text(colour = "black"),
    axis.title = element_text(colour = "black"),
    axis.ticks = element_line(colour = "black"),
    # legend at the bottom 6)
    legend.position = "right"
  )
}

position_jitterdodge(
  jitter.width = NULL,
  jitter.height = 0,
  dodge.width = 0.75,
  seed = NA
)

base_breaks <- function(n = 20){
  function(x) {
    axisTicks(log2(range(x, na.rm = TRUE)), log = TRUE, n = n)
  }
}

dodge <- position_dodge(width = 1)

##############################################################################
# IMPORT FILES

SampleInfo <- readr::read_delim('SampleInfo.txt',',')
mean_set <- readr::read_delim('mean_set.txt',',',col_names = FALSE)
metadata <- readr::read_delim('metadata.txt',',')
feat_names <- readr::read_delim('feat_names.txt',',',col_names = FALSE)
umap_data <- readr::read_delim('umap_data.txt',',',col_names = FALSE)
idx <- readr::read_delim('idx.txt',',',col_names = FALSE)
cell_set <- readr::read_delim('cell_set.txt',',',col_names = FALSE)

avg_clust_cond <- read_excel('avg_cond_clust.xlsx')
avg_clust_reg <- read_excel('avg_reg_clust.xlsx')
avg_clust_condreg <- read_excel('avg_condreg_clust.xlsx')
avg_clust_condreg2 <- read_excel('avg_condreg_clust2.xlsx')

##############################################################################
# MERGE DBS

morph_set = cbind(SampleInfo,metadata,mean_set)

morph_set$Density = morph_set$Density * 100

for (i in 20:35) {
  colnames(morph_set)[i] <- feat_names[i-19];
}
umap_data =  cbind(umap_data ,idx$X1);

colnames(umap_data)[3] = "idx";

for (i in 1:16) {
  colnames(cell_set)[i] <- feat_names[i];
}

##############################################################################
# PLOTS

#PROTEINOPATH PLOTS

pdf(file = "D:/old_win-macbook/R/R/micmac/Tau.pdf", width = 6, height = 4) 

SampleInfo %>%
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(fill=ConditionOrdered, y=Tau, x=Region)) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Region") +
  ylab("Tau Volume (%)") +
  labs(fill = "Condition") +
  ylim(0,2) +
  blue_theme() +
  scale_fill_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) 

dev.off()



pdf(file = "D:/old_win-macbook/R/R/micmac/ALoad.pdf", width = 6, height = 4) 

SampleInfo %>%
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(fill=ConditionOrdered, y=ALoad, x=Region)) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Region") +
  ylab("ALoad Volume (%)") +
  labs(fill = "Condition") +
  ylim(0,4) +
  blue_theme() +
  scale_fill_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) 

dev.off()



pdf(file = "D:/old_win-macbook/R/R/micmac/Psyn.pdf", width = 6, height = 4) 

SampleInfo %>%
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(fill=ConditionOrdered, y=Psyn, x=Region)) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Region") +
  ylab("Psyn Volume (%)") +
  labs(fill = "Condition") +
  ylim(0,0.1) +
  blue_theme() +
  scale_fill_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) 

dev.off()

#CORR PLOTS

SampleInfo %>% 
  ggplot(aes(x = Psyn, y = Tau)) +
  geom_point() + 
  geom_smooth() +
  scale_x_continuous(trans = 'log2') +
  scale_y_continuous(trans = 'log2')

SampleInfo %>%  
  ggplot(aes(x = Psyn, y = Tau)) +
  geom_point(aes(color = Condition, shape = Condition)) + 
  geom_smooth(aes(color = Condition), method = lm, se = FALSE, fullrange = TRUE) +
  scale_x_continuous(trans = 'log2') +
  scale_y_continuous(trans = 'log2')

#BUBBLE PLOT PROTEINOPATH ALL

pdf(file = "D:/old_win-macbook/R/R/micmac/TauPsynBubbleALL.pdf", width = 8, height = 4) 

SampleInfo %>%  
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = Psyn, y = Tau)) +
  geom_point(aes(color = ConditionOrdered, size = ALoad), alpha = 0.5) +
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  scale_size(range = c(0.5, 12))  +
  xlab("Psyn (log2)") +
  ylab("Tau (log2)") +
  labs(color = "Condition",size = "Amyloid Load (% vol)") +
  scale_y_continuous(trans = log_trans(), breaks = base_breaks()) + 
  scale_x_continuous(trans = log_trans(), breaks = base_breaks()) +
  theme(panel.grid.minor = element_blank())

dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/TauALoadBubbleALL.pdf", width = 8, height = 4) 

SampleInfo %>%  
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = ALoad, y = Tau)) +
  geom_point(aes(color = ConditionOrdered, size = Psyn), alpha = 0.5) +
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  scale_size(range = c(0.5, 12))  +
  xlab("Amyloid Load (log2)") +
  ylab("Tau (log2)") +
  labs(color = "Condition",size = "Psyn Load (% vol)") +
  scale_y_continuous(trans = log_trans(), breaks = base_breaks()) + 
  scale_x_continuous(trans = log_trans(), breaks = base_breaks()) +
  theme(panel.grid.minor = element_blank())

dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/PsynALoadBubbleALL.pdf", width = 8, height = 4) 

SampleInfo %>%  
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = ALoad, y = Psyn)) +
  geom_point(aes(color = ConditionOrdered, size = Tau), alpha = 0.5) +
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  scale_size(range = c(0.5, 12))  +
  xlab("Amyloid Load (log2)") +
  ylab("Psyn (log2)") +
  labs(color = "Condition",size = "Tau Load (% vol)") +
  scale_y_continuous(trans = log_trans(), breaks = base_breaks()) + 
  scale_x_continuous(trans = log_trans(), breaks = base_breaks()) +
  theme(panel.grid.minor = element_blank())

dev.off()


#BUBBLE PLOT PROTEINOPATH FACET BY REGION

pdf(file = "D:/old_win-macbook/R/R/micmac/TauPsynBubbleREG.pdf", width = 12, height = 4) 

SampleInfo %>%  
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = Psyn, y = Tau)) +
  geom_point(aes(color = ConditionOrdered, size = ALoad), alpha = 0.5) +
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  scale_size(range = c(0.5, 12))  +
  xlab("Psyn (log2)") +
  ylab("Tau (log2)") +
  labs(color = "Condition",size = "Amyloid Load (% vol)") +
  scale_y_continuous(trans = log_trans(), breaks = base_breaks()) + 
  scale_x_continuous(trans = log_trans(), breaks = base_breaks()) +
  theme(panel.grid.minor = element_blank()) +
  facet_grid(cols = vars(Region))

dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/TauALoadBubbleREG.pdf", width = 12, height = 4) 

SampleInfo %>%  
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = ALoad, y = Tau)) +
  geom_point(aes(color = ConditionOrdered, size = Psyn), alpha = 0.5) +
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  scale_size(range = c(0.5, 12))  +
  xlab("Amyloid Load (log2)") +
  ylab("Tau (log2)") +
  labs(color = "Condition",size = "Psyn Load (% vol)") +
  scale_y_continuous(trans = log_trans(), breaks = base_breaks()) + 
  scale_x_continuous(trans = log_trans(), breaks = base_breaks()) +
  theme(panel.grid.minor = element_blank()) +
  facet_grid(cols = vars(Region))

dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/PsynALoadBubbleREG.pdf", width = 12, height = 4) 

SampleInfo %>%  
  mutate(ConditionOrdered = factor(SampleInfo$Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = ALoad, y = Psyn)) +
  geom_point(aes(color = ConditionOrdered, size = Tau), alpha = 0.5) +
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  scale_size(range = c(0.5, 12))  +
  xlab("Amyloid Load (log2)") +
  ylab("Psyn (log2)") +
  labs(color = "Condition",size = "Tau Load (% vol)") +
  scale_y_continuous(trans = log_trans(), breaks = base_breaks()) + 
  scale_x_continuous(trans = log_trans(), breaks = base_breaks()) +
  theme(panel.grid.minor = element_blank()) +
  facet_grid(cols = vars(Region))

dev.off()


# GENDER

pdf(file = "D:/old_win-macbook/R/R/micmac/GenderTau.pdf", width = 6, height = 4) 

SampleInfo %>%
  ggplot(aes( y=Tau, x = Condition,fill = Gender )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Condition") +
  ylab("Tau Volume (%)") +
  labs(fill = "Gender") +
  ylim(0,4) +
  blue_theme() +
  scale_fill_manual(values = c("#007f5f", "#d4d700"))   

dev.off()



pdf(file = "D:/old_win-macbook/R/R/micmac/GenderALoad.pdf", width = 6, height = 4) 

SampleInfo %>%
  ggplot(aes( y=ALoad, x = Condition,fill = Gender )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Condition") +
  ylab("Amyloid Volume (%)") +
  labs(fill = "Gender") +
  ylim(0,4.5) +
  blue_theme() +
  scale_fill_manual(values = c("#007f5f", "#d4d700"))   
  
dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/GenderPsyn.pdf", width = 6, height = 4) 

SampleInfo %>%
  ggplot(aes( y=Psyn, x = Condition,fill = Gender )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Condition") +
  ylab("Psyn Volume (%)") +
  labs(fill = "Gender") +
  ylim(0,0.5) +
  blue_theme() +
  scale_fill_manual(values = c("#007f5f", "#d4d700"))   
  
dev.off()
  
  # REGION

pdf(file = "D:/old_win-macbook/R/R/micmac/RegTau.pdf", width = 6, height = 4) 

SampleInfo %>%
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes( y=Tau, x = ConditionOrdered,fill = Region )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Tau") +
  ylab("Tau Volume (%)") +
  labs(fill = "Region") +
  ylim(0,5) +
  blue_theme() +
  scale_fill_manual(values = c("#DB7F8E", "#6C698D", "#A5978B"))

dev.off()



pdf(file = "D:/old_win-macbook/R/R/micmac/RegALoad.pdf", width = 6, height = 4) 

SampleInfo %>%
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes( y=ALoad, x = ConditionOrdered,fill = Region )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Tau") +
  ylab("Amyloid Volume (%)") +
  labs(fill = "Region") +
  ylim(0,4.5) +
  blue_theme() +
  scale_fill_manual(values = c("#DB7F8E", "#6C698D", "#A5978B"))

dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/RegPsyn.pdf", width = 6, height = 4) 

SampleInfo %>%
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes( y=Psyn, x = ConditionOrdered,fill = Region )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Tau") +
  ylab("Psyn Volume (%)") +
  labs(fill = "Region") +
  ylim(0,0.5) +
  blue_theme() +
  scale_fill_manual(values = c("#DB7F8E", "#6C698D", "#A5978B")) 

dev.off()

#Morpho Features


for (i in 20:35) {

pdf(file = paste("D:/old_win-macbook/R/R/micmac/Morph_",colnames(morph_set)[i],".pdf",sep = ""), width = 6, height = 4) 
  
abc<- morph_set %>%
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(fill=ConditionOrdered, y=morph_set[,i], x=Region)) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Region") +
  ylab(colnames(morph_set)[i]) +
  labs(fill = "Condition") +
  blue_theme() +
  scale_fill_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a"))

  print(abc)

dev.off()
}

# IBA1

pdf(file = "D:/old_win-macbook/R/R/micmac/iba1Comparison.pdf", width = 6, height = 4) 

morph_set %>%
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes( y=Density, x = Region,fill = ConditionOrdered )) + 
  geom_violin(position= dodge, alpha=0.5,scale = 'width') +
  geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
  xlab("Region") +
  ylab("Iba1 Volume (%)") +
  labs(fill = "Condition") +
  blue_theme() +
  scale_fill_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) 

dev.off()


# POLARITY AND ALOAD IN AD BY SUB-REGION

pdf(file = "D:/old_win-macbook/R/R/micmac/Polarity_in_AD_per_region.pdf", width = 8, height = 4) 

morph_set %>% 
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  filter(ConditionOrdered == 'AD') %>%
  ggplot(aes(x = ALoad, y = X6)) +
  facet_wrap(~variable, scales = "free") +
  geom_point() + 
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  geom_smooth(method = "lm", se = FALSE, color = "black") +
  blue_theme() +
  facet_grid(cols = vars(Region)) +
  xlab("Amyloid Load") +
  ylab("Polarity") +
  theme(panel.grid.minor = element_blank())

dev.off()

# POLARITY AND ALOAD IN ALL CONDITIONS

pdf(file = "D:/old_win-macbook/R/R/micmac/Polarity_vs_ALOAD_in_all_cond.pdf", width = 8, height = 4) 

morph_set %>% 
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  ggplot(aes(x = ALoad, y = X6)) +
  geom_point(scales=  "free") + 
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  geom_smooth(method = "lm", se = FALSE, color = "black",scales="free") +
  blue_theme() +
  xlab("Amyloid Load") +
  ylab("Polarity") +
  theme(panel.grid.minor = element_blank()) +
  facet_wrap(~ConditionOrdered, scales = "free_x")

dev.off()

# MAX CURVATURE IN CTL TAU

pdf(file = "D:/old_win-macbook/R/R/micmac/CurvatureCTL_per_regionTAU.pdf", width = 8, height = 4) 

morph_set %>% 
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  filter(ConditionOrdered == 'CTL') %>%
  ggplot(aes(x = Tau, y = X4)) +
  facet_wrap(~variable, scales = "free") +
  geom_point() + 
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  geom_smooth(method = "lm", se = FALSE, color = "black") +
  blue_theme() +
  facet_grid(cols = vars(Region)) +
  xlab("Tau Load") +
  ylab("Curvature") +
  theme(panel.grid.minor = element_blank())

dev.off()

# MAX CURVATURE IN CTL ALOAD

pdf(file = "D:/old_win-macbook/R/R/micmac/CurvatureCTL_per_regionALOAD.pdf", width = 8, height = 4) 

morph_set %>% 
  mutate(ConditionOrdered = factor(Condition,levels = c('CTL', 'DLB', 'AD'))) %>%
  filter(ConditionOrdered == 'CTL') %>%
  ggplot(aes(x = ALoad, y = X4)) +
  facet_wrap(~variable, scales = "free") +
  geom_point() + 
  scale_color_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) +
  geom_smooth(method = "lm", se = FALSE, color = "black") +
  blue_theme() +
  facet_grid(cols = vars(Region)) +
  xlab("Amyloid Load") +
  ylab("Curvature") +
  theme(panel.grid.minor = element_blank())

dev.off()

# UMAP

pdf(file = "D:/old_win-macbook/R/R/micmac/Umap_cluster.pdf", width = 8, height = 4) 
umap_data %>% 
  mutate(Cluster=factor(idx)) %>%
  ggplot(aes(x = X1, y = X2)) +
  geom_point(aes(color = Cluster), alpha = 0.7, size = 0.7) +
  scale_color_manual(values = c("#005F73", "#0A9396", "#BB3E03", "#CA6702", "#EE9B00", "#E9D8A6", "#94D2BD")) +
  blue_theme() 
dev.off()

pdf(file = "D:/old_win-macbook/R/R/micmac/Umap_compactness.pdf", width = 8, height = 4) 
umap_data %>% 
  mutate(Cluster=factor(idx)) %>%
  ggplot(aes(x = X1, y = X2)) +
  geom_point(aes(color = cell_set$Compactness), alpha = 0.7, size = 0.7) +
  blue_theme() + 
  labs(color = "Compactness")+
  scale_color_viridis(option = "D")
dev.off()

pdf(file = "D:/old_win-macbook/R/R/micmac/Umap_nodedensity.pdf", width = 8, height = 4) 
umap_data %>% 
  mutate(Cluster=factor(idx)) %>%
  ggplot(aes(x = X1, y = X2)) +
  geom_point(aes(color = cell_set$`Node Density`), alpha = 0.7, size = 0.7) +
  blue_theme() + 
  labs(color = "Node Density")+
  scale_color_viridis(option = "D")
dev.off()

pdf(file = "D:/old_win-macbook/R/R/micmac/Umap_polarity.pdf", width = 8, height = 4) 
umap_data %>% 
  mutate(Cluster=factor(idx)) %>%
  ggplot(aes(x = X1, y = X2)) +
  geom_point(aes(color = cell_set$Polarity), alpha = 0.7, size = 0.7) +
  blue_theme() + 
  labs(color = "Polarity")+
  scale_color_viridis(option = "D")
dev.off()

pdf(file = "D:/old_win-macbook/R/R/micmac/Umap_volume.pdf", width = 8, height = 4) 
umap_data %>% 
  mutate(Cluster=factor(idx)) %>%
  ggplot(aes(x = X1, y = X2)) +
  geom_point(aes(color = cell_set$Volume), alpha = 0.7, size = 0.7) +
  blue_theme() + 
  labs(color = "Volume") +
  scale_color_viridis(option = "D")
dev.off()

# VIOLIN PLOT MORPHO CLUSTER

cell_index = cbind(cell_set,idx);
colnames(cell_index)[17] = "idx";

for (i in 1:16) {
  
  pdf(file = paste("D:/old_win-macbook/R/R/micmac/Cluster_Comparison_",feat_names[i],".pdf",sep = ""), width = 6, height = 4) 
  
  abc <- cell_index %>%
    mutate(Cluster=factor(idx)) %>%
    ggplot(aes(fill=Cluster, y=cell_index[,i], x=Cluster)) + 
    geom_violin(position= dodge, alpha=0.5,scale = 'width') +
    geom_boxplot(position= dodge,color="black", alpha=0.5,width = 0.1,lwd=0.25,outlier.shape=NA) +
    xlab("Cluster") +
    ylab(feat_names[i]) +
    blue_theme() +
    theme(legend.position = "none") +
    scale_fill_manual(values = c("#005F73", "#0A9396", "#BB3E03", "#CA6702", "#EE9B00", "#E9D8A6", "#94D2BD"))
  
  
  print(abc)
  
  dev.off()
}

# BARPLOTS CLUSTS

pdf(file = "D:/old_win-macbook/R/R/micmac/Cluster_composition_condition_error.pdf", width = 8, height = 4) 

avg_clust_cond %>%
  mutate(Condition = factor(Condition,levels = c('CTL', 'DLB','AD'))) %>%
  mutate(Cluster = factor(Cluster,levels = c('1', '2','3','4','5','6','7'))) %>%
  ggplot(aes(x=Cluster,y=Average,fill=Condition)) + 
  geom_bar(stat="identity", position="dodge",color="black",size = 0.01) +
  geom_errorbar(aes(ymin=Average, ymax=Average+Std), width=.2,position=position_dodge(0.9),size = 0.01) +
  xlab("Cluster") +
  ylab("Average Composition (%)") +
  scale_fill_manual(values = c("#0f8b8d", "#ec9a29", "#a8201a")) + 
  labs(color = "Condition") +
  blue_theme() +
  ylim(-0.01,0.5) +
  theme(legend.position = "right") 

dev.off()


pdf(file = "D:/old_win-macbook/R/R/micmac/Cluster_composition_region_error.pdf", width = 8, height = 4) 

avg_clust_reg %>%
  mutate(Region = factor(Region,levels = c('CA1', 'CA3','DG'))) %>%
  mutate(Cluster = factor(Cluster,levels = c('1', '2','3','4','5','6','7'))) %>%
  ggplot(aes(x=Cluster,y=Average,fill=Region)) + 
  geom_bar(stat="identity", position="dodge",color="black",size = 0.01) +
  geom_errorbar(aes(ymin=Average, ymax=Average+Std), width=.2,position=position_dodge(0.9),size = 0.01) +
  xlab("Cluster") +
  ylab("Average Composition (%)") +
  scale_fill_manual(values = c("#DB7F8E", "#6C698D", "#A5978B")) +
  labs(color = "Region") +
  blue_theme() +
  ylim(0,0.45) +
  theme(legend.position = "right") 

dev.off()

pdf(file = "D:/old_win-macbook/R/R/micmac/Cluster_composition_regioncond2.pdf", width = 10, height = 4) 

avg_clust_condreg %>%
  mutate(Cluster = factor(Cluster,levels = c('1', '2','3','4','5','6','7'))) %>%
  mutate(Region = factor(Region,levels = c('CA1', 'CA3','DG'))) %>%
  mutate(Condition = factor(Condition,levels = c('CTL', 'DLB','AD'))) %>%
  ggplot(aes(x=Condition,y=Average,fill=Cluster)) + 
  geom_bar(stat="identity", position="dodge",color="black",size = 0.01) +
  xlab("Region per Condition") +
  ylab("Average Composition (%)") +
  facet_grid(~Region) +
  scale_fill_manual(values = c("#005F73", "#0A9396", "#BB3E03", "#CA6702", "#EE9B00", "#E9D8A6", "#94D2BD")) +
  labs(color = "Region") +
  blue_theme() +
  ylim(0,0.4) +
  theme(legend.position = "right") 

dev.off()



#Second version
pdf(file = "D:/old_win-macbook/R/R/micmac/Cluster_composition_regioncond_error.pdf", width = 8, height = 4) 

avg_clust_condreg2 %>%
  mutate(Cluster = factor(Cluster,levels = c('1', '2','3','4','5','6','7'))) %>%
  mutate(Region = factor(Region,levels = c('CA1', 'CA3','DG'))) %>%
  mutate(Condition = factor(Condition,levels = c('CTL', 'DLB','AD'))) %>%
  ggplot(aes(x=Condition,y=Average,fill=Cluster)) + 
  geom_bar(stat="identity", position="dodge",color="black",size = 0.01) +
  geom_errorbar(aes(ymin=Average, ymax=Average+Std), width=.2,position=position_dodge(0.9),size = 0.01) +
  xlab("Region per Condition") +
  ylab("Average Composition (%)") +
  facet_grid(~Region) +
  scale_fill_manual(values = c("#005F73", "#0A9396", "#BB3E03", "#CA6702", "#EE9B00", "#E9D8A6", "#94D2BD")) +
  labs(color = "Region") +
  blue_theme() +
  ylim(0,0.60) +
  theme(legend.position = "right") 

dev.off()