# Script:	Example collapsing analysis statistical test component.
# Version:	0.3
# Contributors:	Slav Petrovski, Quanli Wang
# Last Update:	2018-10-06
# This document is intended for internal teaching use only and shall not be distributed outside of 2018 EMBO Phenotyping neurological syndromes for systems genetics Course.

library(MegaCollapsing)

# read in collapsing matrix data
matrix_file <- "E:/EMBO/example_matrix.txt"
collapsing_matrix <- read.collapsing.matrix(matrix_file)

# read in samples metainfo
sample_file <- "E:/EMBO/samplelist.txt"
samples <- read.sample.list(sample_file)
rownames(samples) <- samples[,"IID"]

# find the common samples from sample mata file and the collapsing matrix, just to make sure they have the same set and order
# Note that the common key for both data matrix is "IID" for individual Identifier
common_sample_list <-intersect(colnames(collapsing_matrix),samples[,"IID"])
collapsing_matrix <- collapsing_matrix[,common_sample_list]

samples <- samples[common_sample_list,]


# get the case control status
is.case <- samples$Phenotype == 2

# compute FET using optimized Fisher test, which compute each unique contingency table only once
ps <- get.pvalues(collapsing_matrix, is.case, n.permutations = 0, with_contingency = TRUE)

# the  p values is stored in ps$observed
fisher.p <- ps$observed
ct <- ps$contingency.table

write.table(fisher.p, file = "E:/EMBO/output.tsv", col.names = FALSE, sep = "\t")
write.table(ct, file = "E:/EMBO/contingency_table.tsv", col.names = FALSE, sep = "\t")






